/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortAssignment {
    private static final Logger LOG = LoggerFactory.getLogger(PortAssignment.class);
    private static final int GLOBAL_BASE_PORT = 11221;
    private static final int GLOBAL_MAX_PORT = Short.MAX_VALUE;
    private static PortRange portRange = null;
    private static int nextPort;

    public static synchronized int unique() {
        if (portRange == null) {
            Integer threadId = Integer.getInteger("zookeeper.junit.threadid");
            portRange = PortAssignment.setupPortRange(System.getProperty("test.junit.threads"), (String)(threadId != null ? "threadid=" + threadId : System.getProperty("sun.java.command")));
            nextPort = portRange.getMinimum();
        }
        int candidatePort = nextPort;
        while (true) {
            if (++candidatePort > portRange.getMaximum()) {
                candidatePort = portRange.getMinimum();
            }
            if (candidatePort == nextPort) {
                throw new IllegalStateException(String.format("Could not assign port from range %s.  The entire range has been exhausted.", portRange));
            }
            try {
                ServerSocket s = new ServerSocket(candidatePort);
                s.close();
                nextPort = candidatePort;
                LOG.info("Assigned port {} from range {}.", (Object)nextPort, (Object)portRange);
                return nextPort;
            }
            catch (IOException e) {
                LOG.debug("Could not bind to port {} from range {}.  Attempting next port.", new Object[]{candidatePort, portRange, e});
                continue;
            }
            break;
        }
    }

    static PortRange setupPortRange(String strProcessCount, String cmdLine) {
        PortRange newPortRange;
        Matcher m;
        Integer processCount = null;
        if (strProcessCount != null && !strProcessCount.isEmpty()) {
            try {
                processCount = Integer.valueOf(strProcessCount);
            }
            catch (NumberFormatException e) {
                LOG.warn("Error parsing test.junit.threads = {}.", (Object)strProcessCount, (Object)e);
            }
        }
        Integer threadId = null;
        if (processCount != null && cmdLine != null && !cmdLine.isEmpty() && (m = Pattern.compile("threadid=(\\d+)").matcher(cmdLine)).find()) {
            try {
                threadId = Integer.valueOf(m.group(1));
            }
            catch (NumberFormatException e) {
                LOG.warn("Error parsing threadid from {}.", (Object)cmdLine, (Object)e);
            }
        }
        if (processCount != null && processCount > 1 && threadId != null) {
            int portRangeSize = 21546 / processCount;
            int minPort = 11221 + (threadId - 1) * portRangeSize;
            int maxPort = minPort + portRangeSize - 1;
            newPortRange = new PortRange(minPort, maxPort);
            LOG.info("Test process {}/{} using ports from {}.", new Object[]{threadId, processCount, newPortRange});
        } else {
            newPortRange = new PortRange(11221, Short.MAX_VALUE);
            LOG.info("Single test process using ports from {}.", (Object)newPortRange);
        }
        return newPortRange;
    }

    private PortAssignment() {
    }

    static final class PortRange {
        private final int minimum;
        private final int maximum;

        PortRange(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        int getMaximum() {
            return this.maximum;
        }

        int getMinimum() {
            return this.minimum;
        }

        public String toString() {
            return String.format("%d - %d", this.minimum, this.maximum);
        }
    }
}

