/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.EnumCounters;

@InterfaceAudience.Private
public class FileWithSnapshotFeature
implements INode.Feature {
    private final FileDiffList diffs;
    private boolean isCurrentFileDeleted = false;

    public FileWithSnapshotFeature(FileDiffList diffs) {
        this.diffs = diffs != null ? diffs : new FileDiffList();
    }

    public boolean isCurrentFileDeleted() {
        return this.isCurrentFileDeleted;
    }

    public void deleteCurrentFile() {
        this.isCurrentFileDeleted = true;
    }

    public FileDiffList getDiffs() {
        return this.diffs;
    }

    public short getMaxBlockRepInDiffs() {
        short max = 0;
        for (FileDiff d : this.getDiffs()) {
            short replication;
            if (d.snapshotINode == null || (replication = ((INodeFileAttributes)d.snapshotINode).getFileReplication()) <= max) continue;
            max = replication;
        }
        return max;
    }

    boolean changedBetweenSnapshots(INodeFile file, Snapshot from, Snapshot to) {
        long laterLength;
        int[] diffIndexPair = this.diffs.changedBetweenSnapshots(from, to);
        if (diffIndexPair == null) {
            return false;
        }
        int earlierDiffIndex = diffIndexPair[0];
        int laterDiffIndex = diffIndexPair[1];
        List diffList = this.diffs.asList();
        long earlierLength = ((FileDiff)diffList.get(earlierDiffIndex)).getFileSize();
        long l = laterLength = laterDiffIndex == diffList.size() ? file.computeFileSize(true, false) : ((FileDiff)diffList.get(laterDiffIndex)).getFileSize();
        if (earlierLength != laterLength) {
            return true;
        }
        INodeFileAttributes earlierAttr = null;
        for (int i = earlierDiffIndex; i < laterDiffIndex; ++i) {
            FileDiff diff = (FileDiff)diffList.get(i);
            if (diff.snapshotINode == null) continue;
            earlierAttr = (INodeFileAttributes)diff.snapshotINode;
            break;
        }
        if (earlierAttr == null) {
            return false;
        }
        INodeFileAttributes laterAttr = (INodeFileAttributes)this.diffs.getSnapshotINode(Math.max(Snapshot.getSnapshotId(from), Snapshot.getSnapshotId(to)), file);
        return !earlierAttr.metadataEquals(laterAttr);
    }

    public String getDetailedString() {
        return (this.isCurrentFileDeleted() ? "(DELETED), " : ", ") + this.diffs;
    }

    public QuotaCounts cleanFile(BlockStoragePolicySuite bsps, INodeFile file, int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (snapshotId == 0x7FFFFFFE) {
            if (!this.isCurrentFileDeleted()) {
                file.recordModification(priorSnapshotId);
                this.deleteCurrentFile();
            }
            this.collectBlocksAndClear(bsps, file, collectedBlocks, removedINodes);
            return new QuotaCounts.Builder().build();
        }
        priorSnapshotId = this.getDiffs().updatePrior(snapshotId, priorSnapshotId);
        return this.diffs.deleteSnapshotDiff(bsps, snapshotId, priorSnapshotId, file, collectedBlocks, removedINodes);
    }

    public void clearDiffs() {
        this.diffs.clear();
    }

    public QuotaCounts updateQuotaAndCollectBlocks(BlockStoragePolicySuite bsps, INodeFile file, FileDiff removed, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        long oldStoragespace = file.storagespaceConsumed();
        byte storagePolicyID = file.getStoragePolicyID();
        BlockStoragePolicy bsp = null;
        EnumCounters<StorageType> typeSpaces = new EnumCounters<StorageType>(StorageType.class);
        if (storagePolicyID != 0) {
            bsp = bsps.getPolicy(file.getStoragePolicyID());
        }
        if (removed.snapshotINode != null) {
            AclFeature aclFeature;
            long oldFileSizeNoRep;
            short replication = ((INodeFileAttributes)removed.snapshotINode).getFileReplication();
            short currentRepl = file.getBlockReplication();
            if (currentRepl == 0) {
                oldFileSizeNoRep = file.computeFileSize(true, true);
                oldStoragespace = oldFileSizeNoRep * (long)replication;
                if (bsp != null) {
                    List<StorageType> oldTypeChosen = bsp.chooseStorageTypes(replication);
                    for (StorageType t : oldTypeChosen) {
                        if (!t.supportTypeQuota()) continue;
                        typeSpaces.add(t, -oldFileSizeNoRep);
                    }
                }
            } else if (replication > currentRepl) {
                oldFileSizeNoRep = file.storagespaceConsumedNoReplication();
                oldStoragespace = oldFileSizeNoRep * (long)replication;
                if (bsp != null) {
                    List<StorageType> oldTypeChosen = bsp.chooseStorageTypes(replication);
                    for (StorageType t : oldTypeChosen) {
                        if (!t.supportTypeQuota()) continue;
                        typeSpaces.add(t, -oldFileSizeNoRep);
                    }
                    List<StorageType> newTypeChosen = bsp.chooseStorageTypes(currentRepl);
                    for (StorageType t : newTypeChosen) {
                        if (!t.supportTypeQuota()) continue;
                        typeSpaces.add(t, oldFileSizeNoRep);
                    }
                }
            }
            if ((aclFeature = ((INodeFileAttributes)removed.getSnapshotINode()).getAclFeature()) != null) {
                AclStorage.removeAclFeature(aclFeature);
            }
        }
        this.getDiffs().combineAndCollectSnapshotBlocks(bsps, file, removed, collectedBlocks, removedINodes);
        long ssDelta = oldStoragespace - file.storagespaceConsumed();
        return new QuotaCounts.Builder().storageSpace(ssDelta).typeSpaces(typeSpaces).build();
    }

    public void collectBlocksAndClear(BlockStoragePolicySuite bsps, INodeFile file, INode.BlocksMapUpdateInfo info, List<INode> removedINodes) {
        BlockInfoContiguous[] snapshotBlocks;
        if (this.isCurrentFileDeleted() && this.getDiffs().asList().isEmpty()) {
            file.destroyAndCollectBlocks(bsps, info, removedINodes);
            return;
        }
        FileDiff diff = (FileDiff)this.getDiffs().getLast();
        long max = this.isCurrentFileDeleted() ? (diff == null ? 0L : diff.getFileSize()) : file.computeFileSize();
        FileDiff last = (FileDiff)this.diffs.getLast();
        BlockInfoContiguous[] blockInfoContiguousArray = snapshotBlocks = last == null ? null : last.getBlocks();
        if (snapshotBlocks == null) {
            file.collectBlocksBeyondMax(max, info);
        } else {
            file.collectBlocksBeyondSnapshot(snapshotBlocks, info);
        }
    }
}

