/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Collection;
import java.util.Stack;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FSPermissionChecker
implements INodeAttributeProvider.AccessControlEnforcer {
    static final Logger LOG = LoggerFactory.getLogger(UserGroupInformation.class);
    private final String fsOwner;
    private final String supergroup;
    private final UserGroupInformation callerUgi;
    private final String user;
    private final Collection<String> groups;
    private final boolean isSuper;
    private final INodeAttributeProvider attributeProvider;

    private static String constructPath(INodeAttributes[] inodes, int end) {
        byte[][] components = new byte[end + 1][];
        for (int i = 0; i <= end; ++i) {
            components[i] = inodes[i].getLocalNameBytes();
        }
        return DFSUtil.byteArray2PathString(components);
    }

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access) {
        return this.toAccessControlString(inodeAttrib, path, access, false);
    }

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access, boolean deniedFromAcl) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.getUser()).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(path).append("\":").append(inodeAttrib.getUserName()).append(':').append(inodeAttrib.getGroupName()).append(':').append(inodeAttrib.isDirectory() ? (char)'d' : '-').append(inodeAttrib.getFsPermission());
        if (deniedFromAcl) {
            sb.append("+");
        }
        return sb.toString();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributeProvider attributeProvider) {
        this.fsOwner = fsOwner;
        this.supergroup = supergroup;
        this.callerUgi = callerUgi;
        this.groups = callerUgi.getGroups();
        this.user = callerUgi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
        this.attributeProvider = attributeProvider;
    }

    public boolean isMemberOfGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public INodeAttributeProvider getAttributesProvider() {
        return this.attributeProvider;
    }

    private INodeAttributeProvider.AccessControlEnforcer getAccessControlEnforcer() {
        return this.attributeProvider != null ? this.attributeProvider.getExternalAccessControlEnforcer(this) : this;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuperUser()) {
            throw new AccessControlException("Access denied for user " + this.getUser() + ". Superuser privilege is required");
        }
    }

    void checkPermission(INodesInPath inodesInPath, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir);
        }
        int snapshotId = inodesInPath.getPathSnapshotId();
        INode[] inodes = inodesInPath.getINodesArray();
        INodeAttributes[] inodeAttrs = new INodeAttributes[inodes.length];
        byte[][] components = inodesInPath.getPathComponents();
        for (int i = 0; i < inodes.length && inodes[i] != null; ++i) {
            inodeAttrs[i] = this.getINodeAttrs(components, i, inodes[i], snapshotId);
        }
        String path = inodesInPath.getPath();
        int ancestorIndex = inodes.length - 2;
        INodeAttributeProvider.AccessControlEnforcer enforcer = this.getAccessControlEnforcer();
        enforcer.checkPermission(this.fsOwner, this.supergroup, this.callerUgi, inodeAttrs, inodes, components, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
    }

    @Override
    public void checkPermission(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] components, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
            --ancestorIndex;
        }
        this.checkTraverse(inodeAttrs, ancestorIndex);
        INodeAttributes last = inodeAttrs[inodeAttrs.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodeAttrs.length > 1 && last != null) {
            this.checkStickyBit(inodeAttrs, inodeAttrs.length - 2);
        }
        if (ancestorAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, ancestorIndex, ancestorAccess);
        }
        if (parentAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, inodeAttrs.length - 2, parentAccess);
        }
        if (access != null) {
            this.check(inodeAttrs, inodeAttrs.length - 1, access);
        }
        if (subAccess != null) {
            INode rawLast = inodes[inodeAttrs.length - 1];
            this.checkSubAccess(components, inodeAttrs.length - 1, rawLast, snapshotId, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(inodeAttrs, inodeAttrs.length - 1);
        }
    }

    private INodeAttributes getINodeAttrs(byte[][] pathByNameArr, int pathIdx, INode inode, int snapshotId) {
        INodeAttributes inodeAttrs = inode.getSnapshotINode(snapshotId);
        if (this.getAttributesProvider() != null) {
            String[] elements = new String[pathIdx + 1];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = DFSUtil.bytes2String(pathByNameArr[i]);
            }
            inodeAttrs = this.getAttributesProvider().getAttributes(elements, inodeAttrs);
        }
        return inodeAttrs;
    }

    private void checkOwner(INodeAttributes[] inodes, int i) throws AccessControlException {
        if (this.getUser().equals(inodes[i].getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied. user=" + this.getUser() + " is not the owner of inode=" + FSPermissionChecker.constructPath(inodes, i));
    }

    private void checkTraverse(INodeAttributes[] inodeAttrs, int last) throws AccessControlException {
        for (int i = 0; i <= last; ++i) {
            INodeAttributes inode = inodeAttrs[i];
            if (!inode.isDirectory()) {
                throw new AccessControlException(FSPermissionChecker.constructPath(inodeAttrs, i) + " (is not a directory)");
            }
            if (this.hasPermission(inode, FsAction.EXECUTE)) continue;
            throw new AccessControlException(this.toAccessControlString(inode, FSPermissionChecker.constructPath(inodeAttrs, i), FsAction.EXECUTE));
        }
    }

    private void checkSubAccess(byte[][] components, int pathIdx, INode inode, int snapshotId, FsAction access, boolean ignoreEmptyDir) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeAttributes inodeAttr;
            INodeDirectory d = (INodeDirectory)directories.pop();
            ReadOnlyList<INode> cList = d.getChildrenList(snapshotId);
            if (!(cList.isEmpty() && ignoreEmptyDir || this.hasPermission(inodeAttr = this.getINodeAttrs(components, pathIdx, d, snapshotId), access))) {
                throw new AccessControlException(this.toAccessControlString(inodeAttr, d.getFullPathName(), access));
            }
            for (INode child : cList) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(INodeAttributes[] inodes, int i, FsAction access) throws AccessControlException {
        INodeAttributes inode;
        INodeAttributes iNodeAttributes = inode = i >= 0 ? inodes[i] : null;
        if (inode != null && !this.hasPermission(inode, access)) {
            throw new AccessControlException(this.toAccessControlString(inode, FSPermissionChecker.constructPath(inodes, i), access));
        }
    }

    private boolean hasPermission(INodeAttributes inode, FsAction access) {
        int firstEntry;
        if (inode == null) {
            return true;
        }
        FsPermission mode = inode.getFsPermission();
        AclFeature aclFeature = inode.getAclFeature();
        if (aclFeature != null && AclEntryStatusFormat.getScope(firstEntry = aclFeature.getEntryAt(0)) == AclEntryScope.ACCESS) {
            return this.hasAclPermission(inode, access, mode, aclFeature);
        }
        FsAction checkAction = this.getUser().equals(inode.getUserName()) ? mode.getUserAction() : (this.isMemberOfGroup(inode.getGroupName()) ? mode.getGroupAction() : mode.getOtherAction());
        return checkAction.implies(access);
    }

    private boolean hasAclPermission(INodeAttributes inode, FsAction access, FsPermission mode, AclFeature aclFeature) {
        boolean foundMatch = false;
        if (this.getUser().equals(inode.getUserName())) {
            if (mode.getUserAction().implies(access)) {
                return true;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            int entry;
            for (int pos = 0; pos < aclFeature.getEntriesSize() && AclEntryStatusFormat.getScope(entry = aclFeature.getEntryAt(pos)) != AclEntryScope.DEFAULT; ++pos) {
                String group;
                AclEntryType type = AclEntryStatusFormat.getType(entry);
                String name = AclEntryStatusFormat.getName(entry);
                if (type == AclEntryType.USER) {
                    if (!this.getUser().equals(name)) continue;
                    FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return true;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP) continue;
                String string = group = name == null ? inode.getGroupName() : name;
                if (!this.isMemberOfGroup(group)) continue;
                FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return true;
                }
                foundMatch = true;
            }
        }
        return !foundMatch && mode.getOtherAction().implies(access);
    }

    private void checkStickyBit(INodeAttributes[] inodes, int index) throws AccessControlException {
        INodeAttributes parent = inodes[index];
        if (!parent.getFsPermission().getStickyBit()) {
            return;
        }
        if (parent.getUserName().equals(this.getUser())) {
            return;
        }
        INodeAttributes inode = inodes[index + 1];
        if (inode.getUserName().equals(this.getUser())) {
            return;
        }
        throw new AccessControlException(String.format("Permission denied by sticky bit: user=%s, path=\"%s\":%s:%s:%s%s, parent=\"%s\":%s:%s:%s%s", this.user, FSPermissionChecker.constructPath(inodes, index + 1), inode.getUserName(), inode.getGroupName(), inode.isDirectory() ? "d" : "-", inode.getFsPermission().toString(), FSPermissionChecker.constructPath(inodes, index), parent.getUserName(), parent.getGroupName(), parent.isDirectory() ? "d" : "-", parent.getFsPermission().toString()));
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.getUser().equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.isMemberOfGroup(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.getUser() + " does not have " + access.toString() + " permissions.");
    }
}

