/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIterator
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private CacheDirectiveInfo filter;
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public CacheDirectiveIterator(ClientProtocol namenode, CacheDirectiveInfo filter, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.filter = filter;
        this.tracer = tracer;
    }

    private static CacheDirectiveInfo removeIdFromFilter(CacheDirectiveInfo filter) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder(filter);
        builder.setId(null);
        return builder.build();
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries = null;
        try (TraceScope scope = this.tracer.newScope("listCacheDirectives");){
            entries = this.namenode.listCacheDirectives(prevKey, this.filter);
        }
        Preconditions.checkNotNull(entries);
        return entries;
    }

    public Long elementToPrevKey(CacheDirectiveEntry entry) {
        return entry.getInfo().getId();
    }

    private static class SingleEntry
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final CacheDirectiveEntry entry;

        public SingleEntry(CacheDirectiveEntry entry) {
            this.entry = entry;
        }

        public CacheDirectiveEntry get(int i) {
            if (i > 0) {
                return null;
            }
            return this.entry;
        }

        public int size() {
            return 1;
        }

        public boolean hasMore() {
            return false;
        }
    }
}

