/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSocketUtil {
    private static final Log LOG = LogFactory.getLog(ServerSocketUtil.class);
    private static Random rand = new Random();

    public static int getPort(int port, int retries) throws IOException {
        int tryPort = port;
        int tries = 0;
        while (true) {
            int n;
            if (tries > 0 || tryPort == 0) {
                tryPort = port + rand.nextInt(65535 - port);
            }
            if (tryPort == 0) continue;
            ServerSocket s = new ServerSocket(tryPort);
            try {
                LOG.info((Object)("Using port " + tryPort));
                n = tryPort;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (++tries >= retries) {
                        LOG.info((Object)"Port is already in use; giving up");
                        throw e;
                    }
                    LOG.info((Object)"Port is already in use; trying again");
                    continue;
                }
            }
            s.close();
            return n;
            break;
        }
    }
}

