/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleMergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectOnDiskMapOutput<K, V>
extends MapOutput<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectOnDiskMapOutput.class);
    private final FileSystem fs;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final DirectShuffleMergeManagerImpl<K, V> merger;
    private final OutputStream disk;
    private long compressedSize;
    private boolean shouldCloseInput;

    public DirectOnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, DirectShuffleMergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput) throws IOException {
        this(mapId, reduceId, merger, size, conf, mapOutputFile, fetcher, primaryMapOutput, FileSystem.get((Configuration)conf), mapOutputFile.getInputFileForWrite(mapId.getTaskID(), size));
    }

    @VisibleForTesting
    DirectOnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, DirectShuffleMergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput, FileSystem fs, Path outputPath) throws IOException {
        super(mapId, size, primaryMapOutput);
        this.fs = fs;
        this.merger = merger;
        this.outputPath = outputPath;
        this.tmpOutputPath = DirectOnDiskMapOutput.getTempPath(outputPath, fetcher);
        this.disk = fs.create(this.tmpOutputPath);
    }

    @VisibleForTesting
    static Path getTempPath(Path outPath, int fetcher) {
        return outPath.suffix(String.valueOf(fetcher));
    }

    public void shuffle(MapHost host, InputStream input, long mapOutputLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        long bytesRead = 0L;
        try {
            byte[] buf = new byte[65536];
            int n = -1;
            n = input.read(buf, 0, buf.length);
            while (n > 0) {
                bytesRead += (long)n;
                metrics.inputBytes((long)n);
                this.disk.write(buf, 0, n);
                reporter.progress();
                n = input.read(buf, 0, buf.length);
            }
            LOG.info("Read " + bytesRead + " bytes from map-output for " + this.getMapId());
            this.disk.close();
            if (this.shouldCloseInput) {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.info("Failed to shuffle from " + this.getMapId(), (Throwable)ioe);
            if (this.shouldCloseInput) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input, this.disk});
            } else {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.disk});
            }
            throw ioe;
        }
        if (bytesRead != mapOutputLength) {
            throw new IOException("Incomplete map output received for " + this.getMapId() + " from " + host.getHostName() + " (" + bytesRead + " instead of " + mapOutputLength + ")");
        }
    }

    public void commit() throws IOException {
        if (!this.fs.rename(this.tmpOutputPath, this.outputPath)) {
            this.fs.delete(this.tmpOutputPath, false);
            throw new IOException("Failed to rename map output " + this.tmpOutputPath + " to " + this.outputPath);
        }
        this.merger.closeOnDiskFile(this.fs.getFileStatus(this.outputPath));
    }

    public void abort() {
        try {
            this.fs.delete(this.tmpOutputPath, false);
        }
        catch (IOException e) {
            LOG.info("failure to clean up " + this.tmpOutputPath, (Throwable)e);
        }
    }

    public String getDescription() {
        return "DISK";
    }
}

