/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

public class ReservationInterval
implements Comparable<ReservationInterval> {
    private final long startTime;
    private final long endTime;

    public ReservationInterval(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isOverlap(long tick) {
        return this.startTime <= tick && tick <= this.endTime;
    }

    @Override
    public int compareTo(ReservationInterval anotherInterval) {
        long diff = 0L;
        diff = this.startTime == anotherInterval.getStartTime() ? this.endTime - anotherInterval.getEndTime() : this.startTime - anotherInterval.getStartTime();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationInterval)) {
            return false;
        }
        ReservationInterval other = (ReservationInterval)obj;
        if (this.endTime != other.endTime) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    public String toString() {
        return "[" + this.startTime + ", " + this.endTime + "]";
    }
}

