/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;

public interface CacheLoaderWriter<K, V> {
    public V load(K var1) throws Exception;

    default public Map<K, V> loadAll(Iterable<? extends K> keys) throws BulkCacheLoadingException, Exception {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (K k : keys) {
            entries.put(k, this.load(k));
        }
        return entries;
    }

    public void write(K var1, V var2) throws Exception;

    default public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws BulkCacheWritingException, Exception {
        for (Map.Entry<K, V> entry : entries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K var1) throws Exception;

    default public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException, Exception {
        for (K k : keys) {
            this.delete(k);
        }
    }
}

