/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.LegacyTls13Verifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAEncryptor;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsCertificate
implements TlsCertificate {
    protected static final int KU_DIGITAL_SIGNATURE = 0;
    protected static final int KU_NON_REPUDIATION = 1;
    protected static final int KU_KEY_ENCIPHERMENT = 2;
    protected static final int KU_DATA_ENCIPHERMENT = 3;
    protected static final int KU_KEY_AGREEMENT = 4;
    protected static final int KU_KEY_CERT_SIGN = 5;
    protected static final int KU_CRL_SIGN = 6;
    protected static final int KU_ENCIPHER_ONLY = 7;
    protected static final int KU_DECIPHER_ONLY = 8;
    protected final JcaTlsCrypto crypto;
    protected final X509Certificate certificate;
    protected DHPublicKey pubKeyDH = null;
    protected ECPublicKey pubKeyEC = null;
    protected PublicKey pubKeyRSA = null;

    public static JcaTlsCertificate convert(JcaTlsCrypto jcaTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof JcaTlsCertificate) {
            return (JcaTlsCertificate)tlsCertificate;
        }
        return new JcaTlsCertificate(jcaTlsCrypto, tlsCertificate.getEncoded());
    }

    public static X509Certificate parseCertificate(JcaJceHelper jcaJceHelper, byte[] byArray) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
            byte[] byArray2 = Certificate.getInstance((Object)aSN1Primitive).getEncoded("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            X509Certificate x509Certificate = (X509Certificate)jcaJceHelper.createCertificateFactory("X.509").generateCertificate(byteArrayInputStream);
            if (byteArrayInputStream.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return x509Certificate;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("unable to decode certificate", generalSecurityException);
        }
    }

    public JcaTlsCertificate(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) throws IOException {
        this(jcaTlsCrypto, JcaTlsCertificate.parseCertificate(jcaTlsCrypto.getHelper(), byArray));
    }

    public JcaTlsCertificate(JcaTlsCrypto jcaTlsCrypto, X509Certificate x509Certificate) {
        this.crypto = jcaTlsCrypto;
        this.certificate = x509Certificate;
    }

    @Override
    public TlsEncryptor createEncryptor(int n) throws IOException {
        this.validateKeyUsageBit(2);
        switch (n) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new JcaTlsRSAEncryptor(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsVerifier createVerifier(short s) throws IOException {
        switch (s) {
            case 7: 
            case 8: {
                int n = SignatureScheme.from((short)8, s);
                Tls13Verifier tls13Verifier = this.createVerifier(n);
                return new LegacyTls13Verifier(n, tls13Verifier);
            }
        }
        this.validateKeyUsageBit(0);
        switch (s) {
            case 2: {
                return new JcaTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new JcaTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                this.validateRSA_PKCS1();
                return new JcaTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(s);
                int n = SignatureScheme.from((short)8, s);
                return new JcaTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n);
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                int n = SignatureScheme.from((short)8, s);
                return new JcaTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public Tls13Verifier createVerifier(int n) throws IOException {
        this.validateKeyUsageBit(0);
        switch (n) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                int n2 = SignatureScheme.getCryptoHashAlgorithm(n);
                String string = this.crypto.getDigestName(n2);
                String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHECDSA";
                return this.crypto.createTls13Verifier(string2, null, this.getPubKeyEC());
            }
            case 2055: {
                return this.crypto.createTls13Verifier("Ed25519", null, this.getPubKeyEd25519());
            }
            case 2056: {
                return this.crypto.createTls13Verifier("Ed448", null, this.getPubKeyEd448());
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                int n3 = SignatureScheme.getCryptoHashAlgorithm(n);
                String string = this.crypto.getDigestName(n3);
                String string3 = RSAUtil.getDigestSigAlgName(string) + "WITHRSA";
                return this.crypto.createTls13Verifier(string3, null, this.getPubKeyRSA());
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(n));
                int n4 = SignatureScheme.getCryptoHashAlgorithm(n);
                String string = this.crypto.getDigestName(n4);
                String string4 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
                AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(n4, string, this.crypto.getHelper());
                return this.crypto.createTls13Verifier(string4, algorithmParameterSpec, this.getPubKeyRSA());
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                int n5 = SignatureScheme.getCryptoHashAlgorithm(n);
                String string = this.crypto.getDigestName(n5);
                String string5 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
                AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(n5, string, this.crypto.getHelper());
                return this.crypto.createTls13Verifier(string5, algorithmParameterSpec, this.getPubKeyRSA());
            }
            case 2308: 
            case 2309: 
            case 2310: {
                return this.crypto.createTls13Verifier("ML-DSA", null, this.getPubKeyMLDSA());
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TlsCryptoException("unable to encode certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        byte[] byArray = this.certificate.getExtensionValue(aSN1ObjectIdentifier.getId());
        return byArray == null ? null : ((ASN1OctetString)ASN1Primitive.fromByteArray((byte[])byArray)).getOctets();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    @Override
    public ASN1Encodable getSigAlgParams() throws IOException {
        byte[] byArray = this.certificate.getSigAlgParams();
        if (null == byArray) {
            return null;
        }
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
        TlsUtils.requireDEREncoding((ASN1Object)aSN1Primitive, byArray);
        return aSN1Primitive;
    }

    DHPublicKey getPubKeyDH() throws IOException {
        try {
            return (DHPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not DH", classCastException);
        }
    }

    DSAPublicKey getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not DSS", classCastException);
        }
    }

    ECPublicKey getPubKeyEC() throws IOException {
        try {
            return (ECPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not EC", classCastException);
        }
    }

    PublicKey getPubKeyEd25519() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!("Ed25519".equals(publicKey.getAlgorithm()) || "EdDSA".equals(publicKey.getAlgorithm()) && publicKey.toString().indexOf("Ed25519") >= 0)) {
            throw new TlsFatalAlert(46, "Public key not Ed25519");
        }
        return publicKey;
    }

    PublicKey getPubKeyEd448() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!("Ed448".equals(publicKey.getAlgorithm()) || "EdDSA".equals(publicKey.getAlgorithm()) && publicKey.toString().indexOf("Ed448") >= 0)) {
            throw new TlsFatalAlert(46, "Public key not Ed448");
        }
        return publicKey;
    }

    PublicKey getPubKeyRSA() throws IOException {
        return this.getPublicKey();
    }

    PublicKey getPubKeyMLDSA() throws IOException {
        return this.getPublicKey();
    }

    @Override
    public short getLegacySignatureAlgorithm() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!this.supportsKeyUsageBit(0)) {
            return -1;
        }
        if (publicKey instanceof RSAPublicKey) {
            return 1;
        }
        if (publicKey instanceof DSAPublicKey) {
            return 2;
        }
        if (publicKey instanceof ECPublicKey) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean supportsSignatureAlgorithm(short s) throws IOException {
        if (!this.supportsKeyUsageBit(0)) {
            return false;
        }
        return this.implSupportsSignatureAlgorithm(s);
    }

    @Override
    public boolean supportsSignatureAlgorithmCA(short s) throws IOException {
        return this.implSupportsSignatureAlgorithm(s);
    }

    @Override
    public TlsCertificate checkUsageInRole(int n) throws IOException {
        switch (n) {
            case 1: {
                this.validateKeyUsageBit(4);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsageBit(4);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected boolean implSupportsSignatureAlgorithm(short s) throws IOException {
        PublicKey publicKey = this.getPublicKey();
        switch (s) {
            case 1: {
                return this.supportsRSA_PKCS1() && publicKey instanceof RSAPublicKey;
            }
            case 2: {
                return publicKey instanceof DSAPublicKey;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return publicKey instanceof ECPublicKey;
            }
            case 7: {
                return "Ed25519".equals(publicKey.getAlgorithm());
            }
            case 8: {
                return "Ed448".equals(publicKey.getAlgorithm());
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && publicKey instanceof RSAPublicKey;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(s) && publicKey instanceof RSAPublicKey;
            }
        }
        return false;
    }

    protected PublicKey getPublicKey() throws IOException {
        try {
            return this.certificate.getPublicKey();
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(42, (Throwable)runtimeException);
        }
    }

    protected SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws IOException {
        return SubjectPublicKeyInfo.getInstance((Object)this.getPublicKey().getEncoded());
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    protected boolean supportsKeyUsageBit(int n) {
        boolean[] blArray = this.certificate.getKeyUsage();
        return null == blArray || blArray.length > n && blArray[n];
    }

    protected boolean supportsRSA_PKCS1() throws IOException {
        AlgorithmIdentifier algorithmIdentifier = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPKCS1(algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_PSS(short s) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPSS_PSS(s, algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_RSAE() throws IOException {
        AlgorithmIdentifier algorithmIdentifier = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPSS_RSAE(algorithmIdentifier);
    }

    protected void validateKeyUsageBit(int n) throws IOException {
        if (!this.supportsKeyUsageBit(n)) {
            switch (n) {
                case 128: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow digital signatures");
                }
                case 8: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key agreement");
                }
                case 32: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key encipherment");
                }
            }
            throw new TlsFatalAlert(80);
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46, "No support for rsa_pkcs1 signature schemes");
        }
    }

    protected void validateRSA_PSS_PSS(short s) throws IOException {
        if (!this.supportsRSA_PSS_PSS(s)) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_pss signature schemes");
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_rsae signature schemes");
        }
    }
}

