/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.cleaner;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubClusterCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SubClusterCleaner.class);
    private FederationStateStoreFacade federationFacade;
    private long heartbeatExpirationMillis;

    public SubClusterCleaner(Configuration conf) {
        this.federationFacade = FederationStateStoreFacade.getInstance((Configuration)conf);
        this.heartbeatExpirationMillis = conf.getTimeDuration("yarn.router.subcluster.heartbeat.expiration.time", YarnConfiguration.DEFAULT_ROUTER_SUBCLUSTER_EXPIRATION_TIME, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        try {
            Date now = new Date();
            LOG.info("SubClusterCleaner at {}.", (Object)now);
            Map subClusters = this.federationFacade.getSubClusters(true);
            for (Map.Entry subCluster : subClusters.entrySet()) {
                SubClusterId subClusterId = (SubClusterId)subCluster.getKey();
                SubClusterInfo subClusterInfo = (SubClusterInfo)subCluster.getValue();
                SubClusterState subClusterState = subClusterInfo.getState();
                long lastHeartBeatTime = subClusterInfo.getLastHeartBeat();
                if (subClusterState.isUsable()) {
                    long heartBeatInterval = now.getTime() - lastHeartBeatTime;
                    try {
                        if (heartBeatInterval <= this.heartbeatExpirationMillis) continue;
                        LOG.info("Deregister SubCluster {} in state {} last heartbeat at {}.", new Object[]{subClusterId, subClusterState, new Date(lastHeartBeatTime)});
                        this.federationFacade.deregisterSubCluster(subClusterId, SubClusterState.SC_LOST);
                    }
                    catch (YarnException e) {
                        LOG.error("deregisterSubCluster failed on SubCluster {}.", (Object)subClusterId, (Object)e);
                    }
                    continue;
                }
                LOG.debug("SubCluster {} in state {} last heartbeat at {}, heartbeat interval < 30mins, no need for Deregister.", new Object[]{subClusterId, subClusterState, new Date(lastHeartBeatTime)});
            }
        }
        catch (Throwable e) {
            LOG.error("SubClusterCleaner Fails.", e);
        }
    }
}

