/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestEnabledECPolicies {
    @Rule
    public Timeout testTimeout = new Timeout(60000);

    private void expectInvalidPolicy(String value) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.ec.system.default.policy", value);
        try {
            ErasureCodingPolicyManager.getInstance().init((Configuration)conf);
            Assert.fail((String)"Expected exception when instantiating ECPolicyManager");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a valid policy", (Throwable)e);
        }
    }

    private void expectValidPolicy(String value, int numEnabled) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ErasureCodingPolicyManager manager = ErasureCodingPolicyManager.getInstance();
        manager.init((Configuration)conf);
        manager.enablePolicy(value);
        Assert.assertEquals((String)"Incorrect number of enabled policies", (long)numEnabled, (long)manager.getEnabledPolicies().length);
    }

    @Test
    public void testDefaultPolicy() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultECPolicies = conf.get("dfs.namenode.ec.system.default.policy", "RS-6-3-1024k");
        this.expectValidPolicy(defaultECPolicies, 1);
    }

    @Test
    public void testInvalid() throws Exception {
        this.expectInvalidPolicy("not-a-policy");
        this.expectInvalidPolicy("not-a-policy," + StripedFileTestUtil.getDefaultECPolicy().getName());
        this.expectInvalidPolicy(StripedFileTestUtil.getDefaultECPolicy().getName() + ", not-a-policy");
        this.expectInvalidPolicy("not-a-policy, ");
        this.expectInvalidPolicy("     ,not-a-policy, ");
    }

    @Test
    public void testValid() throws Exception {
        String ecPolicyName = StripedFileTestUtil.getDefaultECPolicy().getName();
        this.expectValidPolicy(ecPolicyName, 1);
    }

    @Test
    public void testGetPolicies() throws Exception {
        ErasureCodingPolicy[] enabledPolicies = new ErasureCodingPolicy[]{};
        this.testGetPolicies(enabledPolicies);
        enabledPolicies = new ErasureCodingPolicy[]{(ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1)};
        this.testGetPolicies(enabledPolicies);
        enabledPolicies = new ErasureCodingPolicy[]{(ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1), (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(2)};
        this.testGetPolicies(enabledPolicies);
    }

    @Test
    public void testChangeDefaultPolicy() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String testPolicy = "RS-3-2-1024k";
        String defaultPolicy = conf.getTrimmed("dfs.namenode.ec.system.default.policy", "RS-6-3-1024k");
        Assert.assertNotEquals((String)"The default policy and the next default policy should not be the same!", (Object)"RS-3-2-1024k", (Object)defaultPolicy);
        ErasureCodingPolicyManager manager = ErasureCodingPolicyManager.getInstance();
        conf.set("dfs.namenode.ec.system.default.policy", "RS-3-2-1024k");
        manager.init((Configuration)conf);
        manager.loadPolicies(this.constructAllDisabledInitialPolicies(), (Configuration)conf);
        ErasureCodingPolicyInfo[] getPoliciesResult = manager.getPolicies();
        boolean isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPoliciesResult);
        Assert.assertTrue((String)"The new default policy should be in enabled state!", (boolean)isEnabled);
        ErasureCodingPolicyInfo[] getPersistedPoliciesResult = manager.getPersistedPolicies();
        isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPersistedPoliciesResult);
        Assert.assertFalse((String)"The new default policy should be in disabled state in the persisted list!", (boolean)isEnabled);
        manager.disablePolicy("RS-3-2-1024k");
        getPoliciesResult = manager.getPolicies();
        isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPoliciesResult);
        Assert.assertFalse((String)"The new default policy should be in disabled state!", (boolean)isEnabled);
        getPersistedPoliciesResult = manager.getPersistedPolicies();
        isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPersistedPoliciesResult);
        Assert.assertFalse((String)"The new default policy should be in disabled state in the persisted list!", (boolean)isEnabled);
        manager.enablePolicy("RS-3-2-1024k");
        getPoliciesResult = manager.getPolicies();
        isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPoliciesResult);
        Assert.assertTrue((String)"The new default policy should be in enabled state!", (boolean)isEnabled);
        getPersistedPoliciesResult = manager.getPersistedPolicies();
        isEnabled = this.isPolicyEnabled("RS-3-2-1024k", getPersistedPoliciesResult);
        Assert.assertTrue((String)"The new default policy should be in enabled state in the persisted list!", (boolean)isEnabled);
        String emptyPolicy = "";
        conf.set("dfs.namenode.ec.system.default.policy", "");
        manager.init((Configuration)conf);
        manager.loadPolicies(this.constructAllDisabledInitialPolicies(), (Configuration)conf);
        getPoliciesResult = manager.getPolicies();
        this.assertAllPoliciesAreDisabled(getPoliciesResult);
    }

    private void testGetPolicies(ErasureCodingPolicy[] enabledPolicies) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ErasureCodingPolicyManager manager = ErasureCodingPolicyManager.getInstance();
        manager.init((Configuration)conf);
        for (ErasureCodingPolicy p : enabledPolicies) {
            manager.enablePolicy(p.getName());
        }
        HashSet<String> found = new HashSet<String>();
        for (ErasureCodingPolicy p : manager.getEnabledPolicies()) {
            Assert.assertFalse((String)("Duplicate policy name found: " + p.getName()), (boolean)found.contains(p.getName()));
            found.add(p.getName());
        }
        for (ErasureCodingPolicy p : enabledPolicies) {
            Assert.assertTrue((String)("Did not find specified EC policy " + p.getName()), (boolean)found.contains(p.getName()));
        }
        Assert.assertEquals((long)enabledPolicies.length, (long)(found.size() - 1));
        for (ErasureCodingPolicy p : SystemErasureCodingPolicies.getPolicies()) {
            if (found.contains(p.getName())) {
                Assert.assertNotNull((String)("getEnabledPolicyByName did not find enabled policy" + p.getName()), (Object)manager.getEnabledPolicyByName(p.getName()));
                continue;
            }
            Assert.assertNull((String)("getEnabledPolicyByName found disabled policy " + p.getName()), (Object)manager.getEnabledPolicyByName(p.getName()));
        }
    }

    private List<ErasureCodingPolicyInfo> constructAllDisabledInitialPolicies() {
        ArrayList<ErasureCodingPolicyInfo> policies = new ArrayList<ErasureCodingPolicyInfo>();
        for (ErasureCodingPolicy p : SystemErasureCodingPolicies.getPolicies()) {
            policies.add(new ErasureCodingPolicyInfo(p, ErasureCodingPolicyState.DISABLED));
        }
        return policies;
    }

    private boolean isPolicyEnabled(String testPolicy, ErasureCodingPolicyInfo[] policies) {
        for (ErasureCodingPolicyInfo p : policies) {
            if (!testPolicy.equals(p.getPolicy().getName())) continue;
            return p.isEnabled();
        }
        Assert.fail((String)"The result should contain the test policy!");
        return false;
    }

    private void assertAllPoliciesAreDisabled(ErasureCodingPolicyInfo[] policies) {
        for (ErasureCodingPolicyInfo p : policies) {
            Assert.assertTrue((String)"Policy should be disabled", (boolean)p.isDisabled());
        }
    }
}

