/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.api.records.ServiceStatus;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/v1")
public class ApiServer {
    private static final Logger LOG = LoggerFactory.getLogger(ApiServer.class);
    private static Configuration YARN_CONFIG = new YarnConfiguration();
    private ServiceClient serviceClientUnitTest;
    private boolean unitTest = false;

    public ApiServer() {
    }

    @Inject
    public ApiServer(Configuration conf) {
    }

    private static void init() {
    }

    @GET
    @Path(value="/services/version")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8"})
    public Response getVersion() {
        String version = VersionInfo.getBuildVersion();
        LOG.info(version);
        return Response.ok((Object)("{ \"hadoop_version\": \"" + version + "\"}")).build();
    }

    @POST
    @Path(value="/services")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8"})
    public Response createService(@Context HttpServletRequest request, final Service service) {
        ServiceStatus serviceStatus = new ServiceStatus();
        try {
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("POST: createService = {} user = {}", (Object)service, (Object)ugi);
            if (service.getState() == ServiceState.STOPPED) {
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws YarnException, IOException {
                        try (ServiceClient sc = ApiServer.this.getServiceClient();){
                            sc.init(YARN_CONFIG);
                            sc.start();
                            sc.actionBuild(service);
                        }
                        return null;
                    }
                });
                serviceStatus.setDiagnostics("Service " + service.getName() + " version " + service.getVersion() + " saved.");
            } else {
                ApplicationId applicationId = (ApplicationId)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationId>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ApplicationId run() throws IOException, YarnException {
                        try (ServiceClient sc = ApiServer.this.getServiceClient();){
                            ApplicationId applicationId;
                            sc.init(YARN_CONFIG);
                            sc.start();
                            ApplicationId applicationId2 = applicationId = sc.actionCreate(service);
                            return applicationId2;
                        }
                    }
                });
                serviceStatus.setDiagnostics("Application ID: " + applicationId);
            }
            serviceStatus.setState(ServiceState.ACCEPTED);
            serviceStatus.setUri("/v1/services/" + service.getName());
            return this.formatResponse(Response.Status.ACCEPTED, serviceStatus);
        }
        catch (AccessControlException e) {
            serviceStatus.setDiagnostics(e.getMessage());
            return this.formatResponse(Response.Status.FORBIDDEN, e.getCause().getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            String message = "Failed to create service " + service.getName() + ": {}";
            LOG.error(message, (Throwable)e);
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            String message = "Failed to create service " + service.getName() + ": {}";
            LOG.error(message, (Throwable)e);
            message = e.getCause().getMessage().contains("already exists") ? "Service name " + service.getName() + " is already taken." : e.getCause().getMessage();
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, message);
        }
    }

    @GET
    @Path(value="/services/{service_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8"})
    public Response getService(@Context HttpServletRequest request, @PathParam(value="service_name") String appName) {
        ServiceStatus serviceStatus = new ServiceStatus();
        try {
            if (appName == null) {
                throw new IllegalArgumentException("Service name cannot be null.");
            }
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("GET: getService for appName = {} user = {}", (Object)appName, (Object)ugi);
            Service app = this.getServiceFromClient(ugi, appName);
            return Response.ok((Object)app).build();
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            serviceStatus.setDiagnostics(e.getMessage());
            serviceStatus.setCode(RestApiConstants.ERROR_CODE_APP_NAME_INVALID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)serviceStatus).build();
        }
        catch (FileNotFoundException e) {
            serviceStatus.setDiagnostics("Service " + appName + " not found");
            serviceStatus.setCode(RestApiConstants.ERROR_CODE_APP_NAME_INVALID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)serviceStatus).build();
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Get service failed: {}", (Throwable)e);
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            LOG.error("Get service failed: {}", (Throwable)e);
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
    }

    @DELETE
    @Path(value="/services/{service_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8"})
    public Response deleteService(@Context HttpServletRequest request, @PathParam(value="service_name") String appName) {
        try {
            if (appName == null) {
                throw new IllegalArgumentException("Service name can not be null.");
            }
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("DELETE: deleteService for appName = {} user = {}", (Object)appName, (Object)ugi);
            return this.stopService(appName, true, ugi);
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            LOG.error("Fail to stop service: {}", (Throwable)e);
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getCause().getMessage());
        }
        catch (FileNotFoundException | YarnException e) {
            return this.formatResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Fail to stop service: {}", (Throwable)e);
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Response stopService(final String appName, final boolean destroy, UserGroupInformation ugi) throws Exception {
        int result = (Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() throws Exception {
                int result = 0;
                try (ServiceClient sc = ApiServer.this.getServiceClient();){
                    sc.init(YARN_CONFIG);
                    sc.start();
                    Exception stopException = null;
                    try {
                        result = sc.actionStop(appName, destroy);
                        if (result == 0) {
                            LOG.info("Successfully stopped service {}", (Object)appName);
                        }
                    }
                    catch (Exception e) {
                        LOG.info("Got exception stopping service", (Throwable)e);
                        stopException = e;
                    }
                    if (destroy) {
                        result = sc.actionDestroy(appName);
                        if (result == 0) {
                            LOG.info("Successfully deleted service {}", (Object)appName);
                        }
                    } else if (stopException != null) {
                        throw stopException;
                    }
                }
                return result;
            }
        });
        ServiceStatus serviceStatus = new ServiceStatus();
        if (destroy) {
            if (result == 0) {
                serviceStatus.setDiagnostics("Successfully destroyed service " + appName);
                return this.formatResponse(Response.Status.OK, serviceStatus);
            }
            if (result == 44) {
                serviceStatus.setDiagnostics("Service " + appName + " doesn't exist");
                return this.formatResponse(Response.Status.BAD_REQUEST, serviceStatus);
            }
            serviceStatus.setDiagnostics("Service " + appName + " error cleaning up registry");
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, serviceStatus);
        }
        if (result == 40) {
            serviceStatus.setDiagnostics("Service " + appName + " is already stopped");
            return this.formatResponse(Response.Status.BAD_REQUEST, serviceStatus);
        }
        serviceStatus.setDiagnostics("Successfully stopped service " + appName);
        return this.formatResponse(Response.Status.OK, serviceStatus);
    }

    @PUT
    @Path(value="/services/{service_name}/components")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8", "text/plain"})
    public Response updateComponents(@Context HttpServletRequest request, @PathParam(value="service_name") String serviceName, List<Component> requestComponents) {
        try {
            if (requestComponents == null || requestComponents.isEmpty()) {
                throw new YarnException("No components provided.");
            }
            UserGroupInformation ugi = this.getProxyUser(request);
            HashSet<String> compNamesToUpgrade = new HashSet<String>();
            requestComponents.forEach(reqComp -> {
                if (reqComp.getState() != null && reqComp.getState().equals((Object)ComponentState.UPGRADING)) {
                    compNamesToUpgrade.add(reqComp.getName());
                }
            });
            LOG.info("PUT: upgrade components {} for service {} user = {}", new Object[]{compNamesToUpgrade, serviceName, ugi});
            return this.processComponentsUpgrade(ugi, serviceName, compNamesToUpgrade);
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (YarnException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
    }

    @PUT
    @Path(value="/services/{service_name}/components/{component_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8", "text/plain"})
    public Response updateComponent(@Context HttpServletRequest request, final @PathParam(value="service_name") String appName, final @PathParam(value="component_name") String componentName, final Component component) {
        try {
            if (component == null) {
                throw new YarnException("No component data provided");
            }
            if (component.getName() != null && !component.getName().equals(componentName)) {
                String msg = "Component name in the request object (" + component.getName() + ") does not match that in the URI path (" + componentName + ")";
                throw new YarnException(msg);
            }
            UserGroupInformation ugi = this.getProxyUser(request);
            if (component.getState() != null && component.getState().equals((Object)ComponentState.UPGRADING)) {
                LOG.info("PUT: upgrade component {} for service {} user = {}", new Object[]{component.getName(), appName, ugi});
                return this.processComponentsUpgrade(ugi, appName, Sets.newHashSet((Object[])new String[]{componentName}));
            }
            if (component.getNumberOfContainers() == null) {
                throw new YarnException("No container count provided");
            }
            if (component.getNumberOfContainers() < 0L) {
                String message = "Invalid number of containers specified " + component.getNumberOfContainers();
                throw new YarnException(message);
            }
            Map original = (Map)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Map<String, Long>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map<String, Long> run() throws YarnException, IOException {
                    try (ServiceClient sc = new ServiceClient();){
                        Map original;
                        sc.init(YARN_CONFIG);
                        sc.start();
                        Map map = original = sc.flexByRestService(appName, Collections.singletonMap(componentName, component.getNumberOfContainers()));
                        return map;
                    }
                }
            });
            ServiceStatus status = new ServiceStatus();
            status.setDiagnostics("Updating component (" + componentName + ") size from " + original.get(componentName) + " to " + component.getNumberOfContainers());
            return this.formatResponse(Response.Status.OK, status);
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (YarnException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
    }

    @PUT
    @Path(value="/services/{service_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8"})
    public Response updateService(@Context HttpServletRequest request, @PathParam(value="service_name") String appName, Service updateServiceData) {
        try {
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("PUT: updateService for app = {} with data = {} user = {}", new Object[]{appName, updateServiceData, ugi});
            updateServiceData.setName(appName);
            if (updateServiceData.getState() != null && updateServiceData.getState() == ServiceState.FLEX) {
                return this.flexService(updateServiceData, ugi);
            }
            if (updateServiceData.getState() != null && updateServiceData.getState() == ServiceState.STOPPED) {
                return this.stopService(appName, false, ugi);
            }
            if (updateServiceData.getState() != null && updateServiceData.getState() == ServiceState.STARTED) {
                return this.startService(appName, ugi);
            }
            if (updateServiceData.getState() != null && (updateServiceData.getState() == ServiceState.UPGRADING || updateServiceData.getState() == ServiceState.UPGRADING_AUTO_FINALIZE) || updateServiceData.getState() == ServiceState.EXPRESS_UPGRADING) {
                return this.upgradeService(updateServiceData, ugi);
            }
            if (updateServiceData.getState() != null && updateServiceData.getState() == ServiceState.CANCEL_UPGRADING) {
                return this.cancelUpgradeService(appName, ugi);
            }
            if (updateServiceData.getLifetime() != null && updateServiceData.getLifetime() > 0L) {
                return this.updateLifetime(appName, updateServiceData, ugi);
            }
            for (Component c : updateServiceData.getComponents()) {
                if (c.getDecommissionedInstances().size() <= 0) continue;
                return this.decommissionInstances(updateServiceData, ugi);
            }
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getCause().getMessage());
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (FileNotFoundException e) {
            String message = "Application is not found app: " + appName;
            LOG.error(message, (Throwable)e);
            return this.formatResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (YarnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return this.formatResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            String message = "Error while performing operation for app: " + appName;
            LOG.error(message, (Throwable)e);
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @PUT
    @Path(value="/services/{service_name}/components/{component_name}/component-instances/{component_instance_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8", "text/plain"})
    public Response updateComponentInstance(@Context HttpServletRequest request, @PathParam(value="service_name") String serviceName, @PathParam(value="component_name") String componentName, @PathParam(value="component_instance_name") String compInstanceName, Container reqContainer) {
        try {
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("PUT: update component instance {} for component = {} service = {} user = {}", new Object[]{compInstanceName, componentName, serviceName, ugi});
            if (reqContainer == null) {
                throw new YarnException("No container data provided.");
            }
            Service service = this.getServiceFromClient(ugi, serviceName);
            Component component = service.getComponent(componentName);
            if (component == null) {
                throw new YarnException(String.format("The component name in the URI path (%s) is invalid.", componentName));
            }
            Container liveContainer = component.getComponentInstance(compInstanceName);
            if (liveContainer == null) {
                throw new YarnException(String.format("The component (%s) does not have a component instance (%s).", componentName, compInstanceName));
            }
            if (reqContainer.getState() != null && reqContainer.getState().equals((Object)ContainerState.UPGRADING)) {
                return this.processContainersUpgrade(ugi, service, Lists.newArrayList((Object[])new Container[]{liveContainer}));
            }
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (YarnException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @PUT
    @Path(value="/services/{service_name}/component-instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=utf-8", "text/plain"})
    public Response updateComponentInstances(@Context HttpServletRequest request, @PathParam(value="service_name") String serviceName, List<Container> requestContainers) {
        try {
            if (requestContainers == null || requestContainers.isEmpty()) {
                throw new YarnException("No containers provided.");
            }
            UserGroupInformation ugi = this.getProxyUser(request);
            ArrayList<String> toUpgrade = new ArrayList<String>();
            for (Container reqContainer : requestContainers) {
                if (reqContainer.getState() == null || !reqContainer.getState().equals((Object)ContainerState.UPGRADING)) continue;
                toUpgrade.add(reqContainer.getComponentInstanceName());
            }
            if (!toUpgrade.isEmpty()) {
                Service service = this.getServiceFromClient(ugi, serviceName);
                LOG.info("PUT: upgrade component instances {} for service = {} user = {}", new Object[]{toUpgrade, serviceName, ugi});
                List liveContainers = ServiceApiUtil.getLiveContainers((Service)service, toUpgrade);
                return this.processContainersUpgrade(ugi, service, liveContainers);
            }
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (YarnException e) {
            return this.formatResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/services/{service_name}/component-instances")
    @Produces(value={"application/json;charset=utf-8"})
    public Response getComponentInstances(@Context HttpServletRequest request, @PathParam(value="service_name") String serviceName, @QueryParam(value="componentName") List<String> componentNames, @QueryParam(value="version") String version, @QueryParam(value="containerState") List<String> containerStates) {
        try {
            UserGroupInformation ugi = this.getProxyUser(request);
            LOG.info("GET: component instances for service = {}, compNames in {}, version = {}, containerStates in {}, user = {}", new Object[]{serviceName, Objects.toString(componentNames, "[]"), Objects.toString(version, ""), Objects.toString(containerStates, "[]"), ugi});
            List<ContainerState> containerStatesDe = containerStates.stream().map(ContainerState::valueOf).collect(Collectors.toList());
            return Response.ok((Object)this.getContainers(ugi, serviceName, componentNames, version, containerStatesDe)).build();
        }
        catch (IllegalArgumentException iae) {
            return this.formatResponse(Response.Status.BAD_REQUEST, "valid container states are: " + Arrays.toString(ContainerState.values()));
        }
        catch (AccessControlException e) {
            return this.formatResponse(Response.Status.FORBIDDEN, e.getMessage());
        }
        catch (IOException | InterruptedException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            return this.formatResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
    }

    private Response flexService(Service service, UserGroupInformation ugi) throws IOException, InterruptedException {
        final String appName = service.getName();
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        final HashMap<String, String> componentCountStrings = new HashMap<String, String>();
        for (Component c : service.getComponents()) {
            componentCountStrings.put(c.getName(), c.getNumberOfContainers().toString());
        }
        Integer result = (Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() throws YarnException, IOException {
                int result = 0;
                try (ServiceClient sc = new ServiceClient();){
                    sc.init(YARN_CONFIG);
                    sc.start();
                    result = sc.actionFlex(appName, componentCountStrings);
                    Integer n = result;
                    return n;
                }
            }
        });
        if (result == 0) {
            String message = "Service " + appName + " is successfully flexed.";
            LOG.info(message);
            ServiceStatus status = new ServiceStatus();
            status.setDiagnostics(message);
            status.setState(ServiceState.ACCEPTED);
            response = this.formatResponse(Response.Status.ACCEPTED, status);
        }
        return response;
    }

    private Response updateLifetime(final String appName, final Service updateAppData, UserGroupInformation ugi) throws IOException, InterruptedException {
        String newLifeTime = (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String run() throws YarnException, IOException {
                try (ServiceClient sc = ApiServer.this.getServiceClient();){
                    String newLifeTime;
                    sc.init(YARN_CONFIG);
                    sc.start();
                    String string = newLifeTime = sc.updateLifetime(appName, updateAppData.getLifetime().longValue());
                    return string;
                }
            }
        });
        ServiceStatus status = new ServiceStatus();
        status.setDiagnostics("Service (" + appName + ")'s lifeTime is updated to " + newLifeTime + ", " + updateAppData.getLifetime() + " seconds remaining");
        return this.formatResponse(Response.Status.OK, status);
    }

    private Response startService(final String appName, UserGroupInformation ugi) throws IOException, InterruptedException {
        ApplicationId appId = (ApplicationId)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationId>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ApplicationId run() throws YarnException, IOException {
                try (ServiceClient sc = ApiServer.this.getServiceClient();){
                    ApplicationId appId;
                    sc.init(YARN_CONFIG);
                    sc.start();
                    ApplicationId applicationId = appId = sc.actionStartAndGetId(appName);
                    return applicationId;
                }
            }
        });
        LOG.info("Successfully started service " + appName);
        ServiceStatus status = new ServiceStatus();
        status.setDiagnostics("Service " + appName + " is successfully started with ApplicationId: " + appId);
        status.setState(ServiceState.ACCEPTED);
        return this.formatResponse(Response.Status.OK, status);
    }

    private Response upgradeService(Service service, UserGroupInformation ugi) throws IOException, InterruptedException {
        ServiceStatus status = new ServiceStatus();
        ugi.doAs(() -> {
            try (ServiceClient sc = this.getServiceClient();){
                sc.init(YARN_CONFIG);
                sc.start();
                if (service.getState().equals((Object)ServiceState.EXPRESS_UPGRADING)) {
                    sc.actionUpgradeExpress(service);
                } else {
                    sc.initiateUpgrade(service);
                }
            }
            return null;
        });
        LOG.info("Service {} version {} upgrade initialized", (Object)service.getName(), (Object)service.getVersion());
        status.setDiagnostics("Service " + service.getName() + " version " + service.getVersion() + " saved.");
        status.setState(ServiceState.ACCEPTED);
        return this.formatResponse(Response.Status.ACCEPTED, status);
    }

    private Response cancelUpgradeService(String serviceName, UserGroupInformation ugi) throws IOException, InterruptedException {
        int result = (Integer)ugi.doAs(() -> {
            try (ServiceClient sc = this.getServiceClient();){
                sc.init(YARN_CONFIG);
                sc.start();
                int exitCode = sc.actionCancelUpgrade(serviceName);
                Integer n = exitCode;
                return n;
            }
        });
        if (result == 0) {
            ServiceStatus status = new ServiceStatus();
            LOG.info("Service {} cancelling upgrade", (Object)serviceName);
            status.setDiagnostics("Service " + serviceName + " cancelling upgrade.");
            status.setState(ServiceState.ACCEPTED);
            return this.formatResponse(Response.Status.ACCEPTED, status);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private Response processComponentsUpgrade(UserGroupInformation ugi, String serviceName, Set<String> compNames) throws YarnException, IOException, InterruptedException {
        Service service = this.getServiceFromClient(ugi, serviceName);
        if (!service.getState().equals((Object)ServiceState.UPGRADING) && !service.getState().equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE)) {
            throw new YarnException(String.format("The upgrade of service %s has not been initiated.", service.getName()));
        }
        List containersToUpgrade = ServiceApiUtil.validateAndResolveCompsUpgrade((Service)service, compNames);
        Integer result = this.invokeContainersUpgrade(ugi, service, containersToUpgrade);
        if (result == 0) {
            ServiceStatus status = new ServiceStatus();
            status.setDiagnostics("Upgrading components " + Joiner.on((char)',').join(compNames) + ".");
            return this.formatResponse(Response.Status.ACCEPTED, status);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Response processContainersUpgrade(UserGroupInformation ugi, Service service, List<Container> containers) throws YarnException, IOException, InterruptedException {
        if (!service.getState().equals((Object)ServiceState.UPGRADING) && !service.getState().equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE)) {
            throw new YarnException(String.format("The upgrade of service %s has not been initiated.", service.getName()));
        }
        ServiceApiUtil.validateInstancesUpgrade(containers);
        Integer result = this.invokeContainersUpgrade(ugi, service, containers);
        if (result == 0) {
            ServiceStatus status = new ServiceStatus();
            status.setDiagnostics("Upgrading component instances " + containers.stream().map(Container::getId).collect(Collectors.joining(",")) + ".");
            return this.formatResponse(Response.Status.ACCEPTED, status);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private int invokeContainersUpgrade(UserGroupInformation ugi, Service service, List<Container> containers) throws IOException, InterruptedException {
        return (Integer)ugi.doAs(() -> {
            int result1;
            try (ServiceClient sc = this.getServiceClient();){
                sc.init(YARN_CONFIG);
                sc.start();
                result1 = sc.actionUpgrade(service, containers);
            }
            return result1;
        });
    }

    private Response decommissionInstances(Service service, UserGroupInformation ugi) throws IOException, InterruptedException {
        final String appName = service.getName();
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        final ArrayList instances = new ArrayList();
        for (Component c : service.getComponents()) {
            instances.addAll(c.getDecommissionedInstances());
        }
        Integer result = (Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() throws YarnException, IOException {
                int result = 0;
                try (ServiceClient sc = new ServiceClient();){
                    sc.init(YARN_CONFIG);
                    sc.start();
                    result = sc.actionDecommissionInstances(appName, instances);
                    Integer n = result;
                    return n;
                }
            }
        });
        if (result == 0) {
            String message = "Service " + appName + " has successfully decommissioned instances.";
            LOG.info(message);
            ServiceStatus status = new ServiceStatus();
            status.setDiagnostics(message);
            status.setState(ServiceState.ACCEPTED);
            response = this.formatResponse(Response.Status.ACCEPTED, status);
        }
        return response;
    }

    private Service getServiceFromClient(UserGroupInformation ugi, String serviceName) throws IOException, InterruptedException {
        return (Service)ugi.doAs(() -> {
            try (ServiceClient sc = this.getServiceClient();){
                Service app1;
                sc.init(YARN_CONFIG);
                sc.start();
                Service service = app1 = sc.getStatus(serviceName);
                return service;
            }
        });
    }

    private ComponentContainers[] getContainers(UserGroupInformation ugi, String serviceName, List<String> componentNames, String version, List<ContainerState> containerStates) throws IOException, InterruptedException {
        return (ComponentContainers[])ugi.doAs(() -> {
            try (ServiceClient sc = this.getServiceClient();){
                ComponentContainers[] result;
                sc.init(YARN_CONFIG);
                sc.start();
                ComponentContainers[] componentContainersArray = result = sc.getContainers(serviceName, componentNames, version, containerStates);
                return componentContainersArray;
            }
        });
    }

    public void setServiceClient(ServiceClient mockServerClient) {
        this.serviceClientUnitTest = mockServerClient;
        this.unitTest = true;
    }

    private ServiceClient getServiceClient() {
        if (this.unitTest) {
            return this.serviceClientUnitTest;
        }
        return new ServiceClient();
    }

    private UserGroupInformation getProxyUser(HttpServletRequest request) throws AccessControlException {
        String remoteUser = request.getRemoteUser();
        try {
            UserGroupInformation ugi;
            if (UserGroupInformation.isSecurityEnabled()) {
                UserGroupInformation proxyUser = UserGroupInformation.getLoginUser();
                ugi = UserGroupInformation.createProxyUser((String)remoteUser, (UserGroupInformation)proxyUser);
            } else {
                ugi = UserGroupInformation.createRemoteUser((String)remoteUser);
            }
            return ugi;
        }
        catch (IOException e) {
            throw new AccessControlException(e.getCause());
        }
    }

    private Response formatResponse(Response.Status status, String message) {
        ServiceStatus entity = new ServiceStatus();
        entity.setDiagnostics(message);
        return this.formatResponse(status, entity);
    }

    private Response formatResponse(Response.Status status, ServiceStatus entity) {
        return Response.status((Response.Status)status).entity((Object)entity).build();
    }

    static {
        ApiServer.init();
    }
}

