/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SleepJob
extends Configured
implements Tool {
    public static String MAP_SLEEP_COUNT = "mapreduce.sleepjob.map.sleep.count";
    public static String REDUCE_SLEEP_COUNT = "mapreduce.sleepjob.reduce.sleep.count";
    public static String MAP_SLEEP_TIME = "mapreduce.sleepjob.map.sleep.time";
    public static String REDUCE_SLEEP_TIME = "mapreduce.sleepjob.reduce.sleep.time";
    public static final String SLEEP_JOB_NAME = "Sleep job";

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SleepJob(), (String[])args);
        System.exit(res);
    }

    public Job createJob(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) throws IOException {
        return this.createJob(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount, SLEEP_JOB_NAME);
    }

    public Job createJob(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount, String name) throws IOException {
        Configuration conf = this.getConf();
        conf.setLong(MAP_SLEEP_TIME, mapSleepTime);
        conf.setLong(REDUCE_SLEEP_TIME, reduceSleepTime);
        conf.setInt(MAP_SLEEP_COUNT, mapSleepCount);
        conf.setInt(REDUCE_SLEEP_COUNT, reduceSleepCount);
        conf.setInt("mapreduce.job.maps", numMapper);
        Job job = Job.getInstance((Configuration)conf);
        job.setNumReduceTasks(numReducer);
        job.setJarByClass(SleepJob.class);
        job.setMapperClass(SleepMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(SleepReducer.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setInputFormatClass(SleepInputFormat.class);
        job.setPartitionerClass(SleepJobPartitioner.class);
        job.setSpeculativeExecution(false);
        if (SLEEP_JOB_NAME.equals(name)) {
            job.setJobName(SLEEP_JOB_NAME);
        } else {
            job.setJobName("Sleep job - " + name);
        }
        FileInputFormat.addInputPath((Job)job, (Path)new Path("ignored"));
        return job;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            return this.printUsage("number of arguments must be > 0");
        }
        int numMapper = 1;
        int numReducer = 1;
        long mapSleepTime = 100L;
        long reduceSleepTime = 100L;
        long recSleepTime = 100L;
        int mapSleepCount = 1;
        int reduceSleepCount = 1;
        String name = SLEEP_JOB_NAME;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-m")) {
                if ((numMapper = Integer.parseInt(args[++i])) >= 0) continue;
                return this.printUsage(numMapper + ": numMapper must be >= 0");
            }
            if (args[i].equals("-r")) {
                if ((numReducer = Integer.parseInt(args[++i])) >= 0) continue;
                return this.printUsage(numReducer + ": numReducer must be >= 0");
            }
            if (args[i].equals("-mt")) {
                if ((mapSleepTime = Long.parseLong(args[++i])) >= 0L) continue;
                return this.printUsage(mapSleepTime + ": mapSleepTime must be >= 0");
            }
            if (args[i].equals("-rt")) {
                if ((reduceSleepTime = Long.parseLong(args[++i])) >= 0L) continue;
                return this.printUsage(reduceSleepTime + ": reduceSleepTime must be >= 0");
            }
            if (args[i].equals("-recordt")) {
                if ((recSleepTime = Long.parseLong(args[++i])) >= 0L) continue;
                return this.printUsage(recSleepTime + ": recordSleepTime must be >= 0");
            }
            if (!args[i].equals("-name")) continue;
            name = args[++i];
        }
        mapSleepCount = (int)Math.ceil((double)mapSleepTime / (double)recSleepTime);
        Job job = this.createJob(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount = (int)Math.ceil((double)reduceSleepTime / (double)recSleepTime), name);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    private int printUsage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("SleepJob [-m numMapper] [-r numReducer] [-mt mapSleepTime (msec)] [-rt reduceSleepTime (msec)] [-recordt recordSleepTime (msec)] [-name]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        return 2;
    }

    public static class SleepReducer
    extends Reducer<IntWritable, NullWritable, NullWritable, NullWritable> {
        private long reduceSleepDuration = 100L;
        private int reduceSleepCount = 1;
        private int count = 0;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.reduceSleepCount = conf.getInt(REDUCE_SLEEP_COUNT, this.reduceSleepCount);
            this.reduceSleepDuration = this.reduceSleepCount == 0 ? 0L : conf.getLong(REDUCE_SLEEP_TIME, 100L) / (long)this.reduceSleepCount;
        }

        public void reduce(IntWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException {
            try {
                context.setStatus("Sleeping... (" + this.reduceSleepDuration * (long)(this.reduceSleepCount - this.count) + ") ms left");
                Thread.sleep(this.reduceSleepDuration);
            }
            catch (InterruptedException ex) {
                throw (IOException)new IOException("Interrupted while sleeping").initCause(ex);
            }
            ++this.count;
        }
    }

    public static class SleepMapper
    extends Mapper<IntWritable, IntWritable, IntWritable, NullWritable> {
        private long mapSleepDuration = 100L;
        private int mapSleepCount = 1;
        private int count = 0;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.mapSleepCount = conf.getInt(MAP_SLEEP_COUNT, this.mapSleepCount);
            this.mapSleepDuration = this.mapSleepCount == 0 ? 0L : conf.getLong(MAP_SLEEP_TIME, 100L) / (long)this.mapSleepCount;
        }

        public void map(IntWritable key, IntWritable value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                context.setStatus("Sleeping... (" + this.mapSleepDuration * (long)(this.mapSleepCount - this.count) + ") ms left");
                Thread.sleep(this.mapSleepDuration);
            }
            catch (InterruptedException ex) {
                throw (IOException)new IOException("Interrupted while sleeping").initCause(ex);
            }
            ++this.count;
            int k = key.get();
            for (int i = 0; i < value.get(); ++i) {
                context.write((Object)new IntWritable(k + i), (Object)NullWritable.get());
            }
        }
    }

    public static class SleepInputFormat
    extends InputFormat<IntWritable, IntWritable> {
        public List<InputSplit> getSplits(JobContext jobContext) {
            ArrayList<InputSplit> ret = new ArrayList<InputSplit>();
            int numSplits = jobContext.getConfiguration().getInt("mapreduce.job.maps", 1);
            for (int i = 0; i < numSplits; ++i) {
                ret.add(new EmptySplit());
            }
            return ret;
        }

        public RecordReader<IntWritable, IntWritable> createRecordReader(InputSplit ignored, TaskAttemptContext taskContext) throws IOException {
            Configuration conf = taskContext.getConfiguration();
            final int count = conf.getInt(MAP_SLEEP_COUNT, 1);
            if (count < 0) {
                throw new IOException("Invalid map count: " + count);
            }
            int redcount = conf.getInt(REDUCE_SLEEP_COUNT, 1);
            if (redcount < 0) {
                throw new IOException("Invalid reduce count: " + redcount);
            }
            final int emitPerMapTask = redcount * taskContext.getNumReduceTasks();
            return new RecordReader<IntWritable, IntWritable>(){
                private int records = 0;
                private int emitCount = 0;
                private IntWritable key = null;
                private IntWritable value = null;

                public void initialize(InputSplit split, TaskAttemptContext context) {
                }

                public boolean nextKeyValue() throws IOException {
                    if (count == 0) {
                        return false;
                    }
                    this.key = new IntWritable();
                    this.key.set(this.emitCount);
                    int emit = emitPerMapTask / count;
                    if (emitPerMapTask % count > this.records) {
                        ++emit;
                    }
                    this.emitCount += emit;
                    this.value = new IntWritable();
                    this.value.set(emit);
                    return this.records++ < count;
                }

                public IntWritable getCurrentKey() {
                    return this.key;
                }

                public IntWritable getCurrentValue() {
                    return this.value;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return count == 0 ? 100.0f : (float)this.records / (float)count;
                }
            };
        }
    }

    public static class EmptySplit
    extends InputSplit
    implements Writable {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }

    public static class SleepJobPartitioner
    extends Partitioner<IntWritable, NullWritable> {
        public int getPartition(IntWritable k, NullWritable v, int numPartitions) {
            return k.get() % numPartitions;
        }
    }
}

