/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import java.util.Set;
import org.apache.hadoop.util.StringUtils;

public class SchedulerUtils {
    public static String generateFairSchedulerXml(int maxRunningJobs, int userMaxAppsDefault, int maxRunningAppsPerQueue, int numQueues, String schedulingPolicy, int minSharePreemptionTimeout, Set<String> labels) {
        StringBuilder fs = new StringBuilder();
        fs.append("<?xml version=\"1.0\"?>\n");
        fs.append("<allocations>\n");
        fs.append("  <user name=\"default\">\n");
        fs.append(String.format("    <maxRunningJobs>%d</maxRunningJobs>\n", maxRunningJobs));
        fs.append("  </user>\n");
        fs.append(String.format("  <userMaxAppsDefault>%d</userMaxAppsDefault>\n", userMaxAppsDefault));
        double weight = 1.0 / (double)numQueues;
        for (int i = 1; i <= numQueues; ++i) {
            fs.append(String.format("<queue name=\"sls_queue_%d\">\n", i));
            fs.append(String.format("<maxRunningApps>%d</maxRunningApps>\n", maxRunningAppsPerQueue));
            fs.append(String.format("    <schedulingPolicy>%s</schedulingPolicy>\n", schedulingPolicy));
            fs.append(String.format("    <weight>%f</weight>\n", weight));
            fs.append(String.format("    <minSharePreemptionTimeout>%d</minSharePreemptionTimeout>\n", minSharePreemptionTimeout));
            if (labels != null) {
                fs.append(String.format("    <label>%s</label>\n", StringUtils.join((CharSequence)",", labels)));
            }
            fs.append("    <weight>1.0</weight>");
            fs.append("    <aclSubmitApps>*</aclSubmitApps>");
            fs.append("  </queue>\n");
        }
        fs.append("</allocations>");
        return fs.toString();
    }

    public static String generateCapacitySchedulerXml(int numQueues, double maximumCapacityPerQueue, int maxRunningAppsPerQueue, Set<String> labels) {
        StringBuilder cs = new StringBuilder();
        cs.append("<?xml version=\"1.0\"?>\n");
        cs.append("<configuration>\n");
        double queueCapacity = 100.0 / (double)numQueues;
        StringBuilder queues = new StringBuilder();
        for (int queueNumber = 1; queueNumber <= numQueues; ++queueNumber) {
            cs.append(SchedulerUtils.generateProperty(String.format("yarn.scheduler.capacity.root.sls_queue_%d.capacity", queueNumber), String.valueOf(queueCapacity)));
            cs.append(SchedulerUtils.generateProperty(String.format("yarn.scheduler.capacity.root.sls_queue_%d.maximum-capacity", queueNumber), String.valueOf(maximumCapacityPerQueue)));
            if (labels != null) {
                cs.append(SchedulerUtils.generateProperty(String.format("yarn.scheduler.capacity.root.sls_queue_%d.label", queueNumber), StringUtils.join((CharSequence)",", labels)));
            }
            queues.append(String.format("sls_queue_%d", queueNumber));
            if (queueNumber == numQueues) continue;
            queues.append(",");
        }
        cs.append(SchedulerUtils.generateProperty("yarn.scheduler.capacity.root.queues", queues.toString()));
        cs.append(SchedulerUtils.generateProperty("yarn.scheduler.capacity.resource-calculator", "org.apache.hadoop.yarn.util.resource.DominantResourceCalculator"));
        cs.append("</configuration>");
        return cs.toString();
    }

    public static String generateProperty(String name, String value) {
        return "<property>\n    <name>" + name + "</name>    <value>" + value + "</value></property>\n";
    }
}

