/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.yarn.sls.appmaster.MRAMSimulator;

public class JobUtils {
    public static File generateInputJobTraces(List<Job> jobs, File slsOutputDir) {
        ObjectMapper mapper = new ObjectMapper();
        File jobTraces = new File(slsOutputDir.getAbsolutePath() + "/jobTraces.json");
        try {
            if (!slsOutputDir.exists() && !slsOutputDir.mkdirs() || !jobTraces.createNewFile()) {
                System.err.println("ERROR: Cannot create job traces file " + jobTraces.getAbsolutePath());
                System.exit(1);
            }
            for (Job job : jobs) {
                String jsonJob = mapper.writeValueAsString((Object)job);
                Files.write(Paths.get(jobTraces.getAbsolutePath(), new String[0]), jsonJob.getBytes(), StandardOpenOption.APPEND);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jobTraces;
    }

    public static List<Job> generateJobList(int numJobs, int jobStartMs, int jobEndMs, int numTasks, int containerStartMs, int containerEndMs, int numQueues, int numNodes, boolean random, boolean increasingly) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Random rand = new Random();
        for (int jobIndex = 1; jobIndex <= numJobs; ++jobIndex) {
            ArrayList<Task> tasks = new ArrayList<Task>();
            for (int taskIndex = 1; taskIndex <= numTasks; ++taskIndex) {
                int taskDuration = containerEndMs - containerStartMs;
                int taskStart = containerStartMs == 0 ? containerStartMs : (random ? rand.nextInt(containerStartMs) : containerStartMs);
                int taskEnd = random ? rand.nextInt(taskDuration) + taskStart : containerEndMs + taskStart;
                int nodeNumber = rand.nextInt(numNodes);
                String containerType = Math.random() > 0.5 ? "map" : "reduce";
                int containerPriority = containerType.equals("map") ? 20 : 10;
                String containerHost = "/default-rack/" + nodeNumber;
                Task task = new Task(containerHost, increasingly ? taskStart * taskIndex : taskStart, increasingly ? taskEnd * taskIndex : taskEnd, containerPriority, containerType);
                tasks.add(task);
            }
            int jobDuration = jobEndMs - jobStartMs;
            int jobStart = random ? rand.nextInt(jobStartMs == 0 ? 1 : jobStartMs) : jobStartMs;
            int jobEnd = random ? rand.nextInt(jobDuration) + jobStart : jobDuration + jobStart;
            int queueNumber = jobIndex % numQueues;
            String queueName = "sls_queue_" + (queueNumber == 0 ? queueNumber + 1 : queueNumber);
            String jobId = "job_" + jobIndex;
            Job job = new Job("mapreduce", increasingly ? jobStart * jobIndex : jobStart, increasingly ? jobEnd * jobIndex : jobEnd, queueName, jobId, "default", tasks);
            jobs.add(job);
        }
        return jobs;
    }

    public static void setMRAMSimulatorParameters(int memory, int vcores) {
        try {
            FieldUtils.writeStaticField(MRAMSimulator.class, (String)"MR_AM_CONTAINER_RESOURCE_MEMORY_MB", (Object)memory, (boolean)true);
            FieldUtils.writeStaticField(MRAMSimulator.class, (String)"MR_AM_CONTAINER_RESOURCE_VCORES", (Object)vcores, (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static class Task {
        @JsonProperty(value="container.host")
        private String containerHost;
        @JsonProperty(value="container.start.ms")
        private int containerStartMs;
        @JsonProperty(value="container.end.ms")
        private int containerEndMs;
        @JsonProperty(value="container.priority")
        private int contanierPriority;
        @JsonProperty(value="container.type")
        private String containerType;

        public Task(String containerHost, int containerStartMs, int containerEndMs, int contanierPriority, String containerType) {
            this.containerHost = containerHost;
            this.containerStartMs = containerStartMs;
            this.containerEndMs = containerEndMs;
            this.contanierPriority = contanierPriority;
            this.containerType = containerType;
        }

        public String getContainerHost() {
            return this.containerHost;
        }

        public int getContainerStartMs() {
            return this.containerStartMs;
        }

        public int getContainerEndMs() {
            return this.containerEndMs;
        }

        public int getContanierPriority() {
            return this.contanierPriority;
        }

        public String getContainerType() {
            return this.containerType;
        }
    }

    public static class Job {
        @JsonProperty(value="am.type")
        private String amType;
        @JsonProperty(value="job.start.ms")
        private int jobStartMs;
        @JsonProperty(value="job.end.ms")
        private int jobEndMs;
        @JsonProperty(value="job.queue.name")
        private String queueName;
        @JsonProperty(value="job.id")
        private String jobId;
        @JsonProperty(value="job.user")
        private String jobUser;
        @JsonProperty(value="job.tasks")
        private List<Task> jobTasks;

        public Job(String amType, int jobStartMs, int jobEndMs, String queueName, String jobId, String jobUser, List<Task> jobTasks) {
            this.amType = amType;
            this.jobStartMs = jobStartMs;
            this.jobEndMs = jobEndMs;
            this.queueName = queueName;
            this.jobId = jobId;
            this.jobUser = jobUser;
            this.jobTasks = jobTasks;
        }

        public String getAmType() {
            return this.amType;
        }

        public int getJobStartMs() {
            return this.jobStartMs;
        }

        public int getJobEndMs() {
            return this.jobEndMs;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getJobUser() {
            return this.jobUser;
        }

        public List<Task> getJobTasks() {
            return this.jobTasks;
        }
    }
}

