/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.TableMapping;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.resourcemanager.MockAMLauncher;
import org.apache.hadoop.yarn.sls.scheduler.SLSCapacityScheduler;
import org.apache.hadoop.yarn.sls.scheduler.SLSFairScheduler;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;

public class RMRunner {
    private ResourceManager rm;
    private String metricsOutputDir;
    private Configuration conf;
    private SLSRunner slsRunner;
    private String tableMapping;
    private Map<String, Integer> queueAppNumMap;

    public RMRunner(Configuration conf, SLSRunner slsRunner) {
        this.conf = conf;
        this.slsRunner = slsRunner;
        this.queueAppNumMap = new HashMap<String, Integer>();
    }

    public void startRM() throws ClassNotFoundException, YarnException {
        YarnConfiguration rmConf = new YarnConfiguration(this.conf);
        String schedulerClass = rmConf.get("yarn.resourcemanager.scheduler.class");
        if (Class.forName(schedulerClass) == CapacityScheduler.class) {
            rmConf.set("yarn.resourcemanager.scheduler.class", SLSCapacityScheduler.class.getName());
            rmConf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
            rmConf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getName());
        } else if (Class.forName(schedulerClass) == FairScheduler.class) {
            rmConf.set("yarn.resourcemanager.scheduler.class", SLSFairScheduler.class.getName());
        } else if (Class.forName(schedulerClass) == FifoScheduler.class) {
            throw new YarnException("Fifo Scheduler is not supported yet.");
        }
        rmConf.setClass("net.topology.node.switch.mapping.impl", TableMapping.class, DNSToSwitchMapping.class);
        rmConf.set("net.topology.table.file.name", this.tableMapping);
        rmConf.set("yarn.sls.metrics.output", this.metricsOutputDir);
        this.rm = new ResourceManager(){

            protected ApplicationMasterLauncher createAMLauncher() {
                return new MockAMLauncher(RMRunner.this.slsRunner, (RMContext)this.rmContext);
            }
        };
        JvmMetrics jvmMetrics = JvmMetrics.initSingleton((String)"ResourceManager", null);
        jvmMetrics.registerIfNeeded();
        this.rm.init((Configuration)rmConf);
        this.rm.start();
    }

    public void increaseQueueAppNum(String queue) throws YarnException {
        SchedulerWrapper wrapper = (SchedulerWrapper)this.rm.getResourceScheduler();
        String queueName = wrapper.getRealQueueName(queue);
        Integer appNum = this.queueAppNumMap.get(queueName);
        appNum = appNum == null ? Integer.valueOf(1) : Integer.valueOf(appNum + 1);
        this.queueAppNumMap.put(queueName, appNum);
        SchedulerMetrics metrics = wrapper.getSchedulerMetrics();
        if (metrics != null) {
            metrics.trackQueue(queueName);
        }
    }

    public void setMetricsOutputDir(String metricsOutputDir) {
        this.metricsOutputDir = metricsOutputDir;
    }

    public String getTableMapping() {
        return this.tableMapping;
    }

    public void setTableMapping(String tableMapping) {
        this.tableMapping = tableMapping;
    }

    public void stop() {
        this.rm.stop();
    }

    public ResourceManager getRm() {
        return this.rm;
    }

    public Map<String, Integer> getQueueAppNumMap() {
        return this.queueAppNumMap;
    }
}

