/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class MapRUtil {
    private static final Log LOG = LogFactory.getLog(MapRUtil.class);
    private static final String HBASE_URI_PREFIX = "hbase://";
    private static final byte[] HBASE_URI_PREFIX_BYTES = Bytes.toBytes("hbase://");

    protected MapRUtil() {
    }

    public static String adjustTableNameString(String tableName) {
        return tableName.startsWith(HBASE_URI_PREFIX) ? tableName.substring(tableName.lastIndexOf(47) + 1) : tableName;
    }

    public static TableName adjustTableName(TableName tableName) {
        String alias = tableName.getAliasAsString();
        if (alias.startsWith(HBASE_URI_PREFIX)) {
            return TableName.valueOfWithAlias(alias.substring(alias.lastIndexOf(47) + 1), alias);
        }
        return tableName;
    }

    public static byte[] adjustTableName(String tableName) {
        return MapRUtil.adjustTableName(Bytes.toBytes(tableName));
    }

    public static byte[] adjustTableName(byte[] tableName) {
        if (Bytes.startsWith(tableName, HBASE_URI_PREFIX_BYTES)) {
            int i;
            for (i = tableName.length - 1; i >= HBASE_URI_PREFIX_BYTES.length && tableName[i] != 47; --i) {
            }
            return Arrays.copyOfRange(tableName, i + 1, tableName.length);
        }
        return (byte[])tableName.clone();
    }
}

