/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;

@Metrics(about="Metrics for timeline reader", context="timelineservice")
public class TimelineReaderMetrics {
    private static final MetricsInfo METRICS_INFO = Interns.info((String)"TimelineReaderMetrics", (String)"Metrics for TimelineReader");
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static TimelineReaderMetrics instance = null;
    @Metric(about="GET entities failure latency", valueName="latency")
    private MutableQuantiles getEntitiesFailureLatency;
    @Metric(about="GET entities success latency", valueName="latency")
    private MutableQuantiles getEntitiesSuccessLatency;
    @Metric(about="GET entity types failure latency", valueName="latency")
    private MutableQuantiles getEntityTypesFailureLatency;
    @Metric(about="GET entity types success latency", valueName="latency")
    private MutableQuantiles getEntityTypesSuccessLatency;

    @VisibleForTesting
    protected TimelineReaderMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimelineReaderMetrics getInstance() {
        if (isInitialized.get()) return instance;
        Class<TimelineReaderMetrics> clazz = TimelineReaderMetrics.class;
        synchronized (TimelineReaderMetrics.class) {
            if (instance != null) return instance;
            instance = (TimelineReaderMetrics)DefaultMetricsSystem.initialize((String)"TimelineService").register(METRICS_INFO.name(), METRICS_INFO.description(), (Object)new TimelineReaderMetrics());
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void destroy() {
        isInitialized.set(false);
        instance = null;
    }

    @VisibleForTesting
    public MutableQuantiles getGetEntitiesSuccessLatency() {
        return this.getEntitiesSuccessLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getGetEntitiesFailureLatency() {
        return this.getEntitiesFailureLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getGetEntityTypesSuccessLatency() {
        return this.getEntityTypesSuccessLatency;
    }

    @VisibleForTesting
    public MutableQuantiles getGetEntityTypesFailureLatency() {
        return this.getEntityTypesFailureLatency;
    }

    public void addGetEntitiesLatency(long durationMs, boolean succeeded) {
        if (succeeded) {
            this.getEntitiesSuccessLatency.add(durationMs);
        } else {
            this.getEntitiesFailureLatency.add(durationMs);
        }
    }

    public void addGetEntityTypesLatency(long durationMs, boolean succeeded) {
        if (succeeded) {
            this.getEntityTypesSuccessLatency.add(durationMs);
        } else {
            this.getEntityTypesFailureLatency.add(durationMs);
        }
    }
}

