/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class CheckUploadContentTypeFilter
implements Filter {
    private static final Set<String> UPLOAD_OPERATIONS = new HashSet<String>();

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String op;
        boolean contentTypeOK = true;
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        String method = httpReq.getMethod();
        if ((method.equals("PUT") || method.equals("POST")) && (op = httpReq.getParameter("op")) != null && UPLOAD_OPERATIONS.contains(StringUtils.toUpperCase((String)op)) && "true".equalsIgnoreCase(httpReq.getParameter("data"))) {
            String contentType = httpReq.getContentType();
            boolean bl = contentTypeOK = "application/octet-stream".equalsIgnoreCase(contentType) || "plain/text".equalsIgnoreCase(contentType);
        }
        if (contentTypeOK) {
            chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpRes);
        } else {
            httpRes.sendError(400, "Data upload requests must have content-type set to 'application/octet-stream'");
        }
    }

    public void destroy() {
    }

    static {
        UPLOAD_OPERATIONS.add(HttpFSFileSystem.Operation.APPEND.toString());
        UPLOAD_OPERATIONS.add(HttpFSFileSystem.Operation.CREATE.toString());
    }
}

