/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDoAsEffectiveUser
extends TestRpcBase {
    private static final String REAL_USER_NAME = "realUser1@HADOOP.APACHE.ORG";
    private static final String REAL_USER_SHORT_NAME = "realUser1";
    private static final String PROXY_USER_NAME = "proxyUser";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private TestRpcBase.TestRpcService client;
    private static final Configuration masterConf = new Configuration();
    public static final Logger LOG = LoggerFactory.getLogger(TestDoAsEffectiveUser.class);

    @Before
    public void setMasterConf() throws IOException {
        UserGroupInformation.setConfiguration((Configuration)masterConf);
        this.refreshConf(masterConf);
    }

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info("Local Ip addresses: " + builder.toString());
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(superUserShortName), new String[]{builder.toString()});
    }

    @Test
    public void testCreateProxyUser() throws Exception {
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi);
        UserGroupInformation curUGI = (UserGroupInformation)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertEquals((Object)"proxyUser (auth:PROXY) via realUser1@HADOOP.APACHE.ORG (auth:SIMPLE)", (Object)curUGI.toString());
    }

    private void checkRemoteUgi(final UserGroupInformation ugi, final Configuration conf) throws Exception {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws ServiceException {
                TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                String currentUser = TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                String serverRemoteUser = TestDoAsEffectiveUser.this.client.getServerRemoteUser(null, TestRpcBase.newEmptyRequest()).getUser();
                Assert.assertEquals((Object)ugi.toString(), (Object)currentUser);
                Assert.assertEquals((Object)ugi.toString(), (Object)serverRemoteUser);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000000L)
    public void testRealUserSetup() throws IOException {
        Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 5);
        this.refreshConf(conf);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            this.checkRemoteUgi(realUserUgi, conf);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            this.checkRemoteUgi(proxyUserUgi, conf);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000000L)
    public void testRealUserAuthorizationSuccess() throws IOException {
        Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 5);
        this.refreshConf(conf);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            this.checkRemoteUgi(realUserUgi, conf);
            realUserUgi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            this.checkRemoteUgi(proxyUserUgi, conf);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_SHORT_NAME), new String[]{"20.20.20.20"});
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 5);
        this.refreshConf(conf);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws ServiceException {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                    return TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{GROUP1_NAME});
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 2);
        this.refreshConf(conf);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws ServiceException {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                    return TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 2);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws ServiceException {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                    return TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), new String[]{"group3"});
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 2);
        this.refreshConf(conf);
        try {
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
            String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws ServiceException {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                    return TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                TestDoAsEffectiveUser.stop((Server)server, this.client);
                throw throwable;
            }
            TestDoAsEffectiveUser.stop((Server)server, this.client);
        }
        TestDoAsEffectiveUser.stop((Server)server, this.client);
    }

    @Test
    public void testProxyWithToken() throws Exception {
        final Configuration conf = new Configuration(masterConf);
        TestRpcBase.TestTokenSecretManager sm = new TestRpcBase.TestTokenSecretManager();
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)conf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(conf, 5, sm);
        UserGroupInformation current = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        TestRpcBase.TestTokenIdentifier tokenId = new TestRpcBase.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)current, (String[])GROUP_NAMES);
        proxyUserUgi.addToken(token);
        this.refreshConf(conf);
        String retVal = (String)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                String string;
                try {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, conf);
                    string = TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        TestDoAsEffectiveUser.stop(this.val$server, new TestRpcBase.TestRpcService[]{TestDoAsEffectiveUser.this.client});
                        throw throwable;
                    }
                }
                TestDoAsEffectiveUser.stop(this.val$server, new TestRpcBase.TestRpcService[]{TestDoAsEffectiveUser.this.client});
                return string;
            }
        });
        Assert.assertEquals((Object)"realUser1@HADOOP.APACHE.ORG (auth:CUSTOM) via SomeSuperUser (auth:SIMPLE)", (Object)retVal);
    }

    @Test
    public void testTokenBySuperUser() throws Exception {
        TestRpcBase.TestTokenSecretManager sm = new TestRpcBase.TestTokenSecretManager();
        final Configuration newConf = new Configuration(masterConf);
        newConf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        newConf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)newConf);
        RPC.setProtocolEngine((Configuration)newConf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)newConf);
        RPC.Server server = TestDoAsEffectiveUser.setupTestServer(newConf, 5, sm);
        UserGroupInformation current = UserGroupInformation.createUserForTesting((String)REAL_USER_NAME, (String[])GROUP_NAMES);
        this.refreshConf(newConf);
        TestRpcBase.TestTokenIdentifier tokenId = new TestRpcBase.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        current.addToken(token);
        String retVal = (String)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public String run() throws Exception {
                String string;
                try {
                    TestDoAsEffectiveUser.this.client = TestDoAsEffectiveUser.getClient(addr, newConf);
                    string = TestDoAsEffectiveUser.this.client.getCurrentUser(null, TestRpcBase.newEmptyRequest()).getUser();
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        TestDoAsEffectiveUser.stop(this.val$server, new TestRpcBase.TestRpcService[]{TestDoAsEffectiveUser.this.client});
                        throw throwable;
                    }
                }
                TestDoAsEffectiveUser.stop(this.val$server, new TestRpcBase.TestRpcService[]{TestDoAsEffectiveUser.this.client});
                return string;
            }
        });
        String expected = "realUser1@HADOOP.APACHE.ORG (auth:CUSTOM) via SomeSuperUser (auth:SIMPLE)";
        Assert.assertEquals((String)(retVal + "!=" + expected), (Object)expected, (Object)retVal);
    }

    private void refreshConf(Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    static {
        masterConf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
    }
}

