/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.producers.ProducerArbiter;

public final class TransformerOnTerminateResume<T>
implements Observable.Transformer<T, T> {
    final Func1<Throwable, Observable<T>> onError;
    final Observable<T> onCompleted;

    public TransformerOnTerminateResume(Func1<Throwable, Observable<T>> onError, Observable<T> onCompleted) {
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    public Observable<T> call(final Observable<T> o) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> t) {
                OnTerminateResumeSubscriber parent = new OnTerminateResumeSubscriber(t, TransformerOnTerminateResume.this.onError, TransformerOnTerminateResume.this.onCompleted);
                t.add(parent);
                t.setProducer((Producer)parent.arbiter);
                o.unsafeSubscribe(parent);
            }
        });
    }

    static final class OnTerminateResumeSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<Throwable, Observable<T>> onError;
        final Observable<T> onCompleted;
        final ProducerArbiter arbiter = new ProducerArbiter();
        long produced;

        public OnTerminateResumeSubscriber(Subscriber<? super T> actual, Func1<Throwable, Observable<T>> onError, Observable<T> onCompleted) {
            this.actual = actual;
            this.onError = onError;
            this.onCompleted = onCompleted;
        }

        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        public void onError(Throwable e) {
            Observable o;
            long p = this.produced;
            if (p != 0L) {
                this.arbiter.produced(p);
            }
            try {
                o = (Observable)this.onError.call((Object)e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{e, ex}));
                return;
            }
            if (o == null) {
                this.actual.onError((Throwable)new NullPointerException("The onError function returned a null Observable."));
            } else {
                o.unsafeSubscribe(new ResumeSubscriber<T>(this.actual, this.arbiter));
            }
        }

        public void onCompleted() {
            long p = this.produced;
            if (p != 0L) {
                this.arbiter.produced(p);
            }
            this.onCompleted.unsafeSubscribe(new ResumeSubscriber<T>(this.actual, this.arbiter));
        }

        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        static final class ResumeSubscriber<T>
        extends Subscriber<T> {
            final Subscriber<? super T> actual;
            final ProducerArbiter arbiter;

            public ResumeSubscriber(Subscriber<? super T> actual, ProducerArbiter arbiter) {
                this.actual = actual;
                this.arbiter = arbiter;
            }

            public void onCompleted() {
                this.actual.onCompleted();
            }

            public void onError(Throwable e) {
                this.actual.onError(e);
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public void setProducer(Producer p) {
                this.arbiter.setProducer(p);
            }
        }
    }
}

