/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import org.apache.hadoop.yarn.conf.DefaultYarnConfiguration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ExternalTokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalTokenManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalTokenManagerFactory.class);
    private static ExternalTokenManager extTokenManager;

    public static ExternalTokenManager get() {
        return extTokenManager;
    }

    static {
        YarnConfiguration conf = DefaultYarnConfiguration.get();
        Class clazz = conf.getClass("yarn.external.token.manager", null, ExternalTokenManager.class);
        if (clazz != null) {
            try {
                extTokenManager = (ExternalTokenManager)clazz.newInstance();
            }
            catch (Exception e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Initialized external token manager class - " + clazz.getName());
            }
        }
    }
}

