/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event.multidispatcher;

import org.apache.hadoop.conf.Configuration;

class MultiDispatcherConfig
extends Configuration {
    private final String prefix;

    public MultiDispatcherConfig(Configuration configuration, String dispatcherName) {
        super(configuration);
        this.prefix = String.format("yarn.dispatcher.multi-thread.%s.", dispatcherName);
    }

    public int getDefaultPoolSize() {
        return super.getInt(this.prefix + "default-pool-size", 4);
    }

    public int getQueueSize() {
        return super.getInt(this.prefix + "queue-size", 1000000);
    }

    public int getMonitorSeconds() {
        return super.getInt(this.prefix + "monitor-seconds", 0);
    }

    public int getGracefulStopSeconds() {
        return super.getInt(this.prefix + "graceful-stop-seconds", 60);
    }

    public boolean getMetricsEnabled() {
        return super.getBoolean(this.prefix + "metrics-enabled", false);
    }
}

