/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.scram;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class ScramClientCallbackHandler
implements CallbackHandler {
    private final String password;
    private final String userName;

    public ScramClientCallbackHandler(String password, Token<? extends TokenIdentifier> token) {
        this.userName = ScramClientCallbackHandler.encodeIdentifier(token.getIdentifier());
        this.password = password;
    }

    public static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier));
    }

    public static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password)).toCharArray();
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                if (this.userName != null) {
                    nc.setName(this.userName);
                    continue;
                }
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.password != null) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                String errorMessage = "Could not login: the client is being asked for a password, but the client code does not currently support obtaining a password from the user.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                rc.setText(rc.getDefaultText());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                String authId = ac.getAuthenticationID();
                String authzId = ac.getAuthorizationID();
                ac.setAuthorized(authId.equals(authzId));
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzId);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
        }
    }
}

