/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;

public abstract class RpcAuthMethod {
    private static final String[] LOGIN_MODULES = new String[0];
    @Deprecated
    protected final byte authcode;
    protected final String simpleName;
    protected final String mechanismName;
    protected final UserGroupInformation.AuthenticationMethod authenticationMethod;

    protected RpcAuthMethod(byte code, String simpleName, String mechanismName, UserGroupInformation.AuthenticationMethod authMethod) {
        this.authcode = code;
        this.simpleName = simpleName;
        this.mechanismName = mechanismName;
        this.authenticationMethod = authMethod;
    }

    @Deprecated
    public byte getAuthCode() {
        return this.authcode;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public UserGroupInformation.AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public CallbackHandler createCallbackHandler() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support createCallbackHandler()");
    }

    public final int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof RpcAuthMethod) {
            RpcAuthMethod other = (RpcAuthMethod)that;
            this.getClass().getName().equals(other.getClass().getName());
        }
        return false;
    }

    public String[] loginModules() {
        return LOGIN_MODULES;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.authcode);
    }

    public UserGroupInformation getUser(UserGroupInformation ticket) {
        return ticket;
    }

    public void writeUGI(UserGroupInformation ugi, IpcConnectionContextProtos.UserInformationProto.Builder ugiProto) {
    }

    public UserGroupInformation getAuthorizedUgi(String authorizedId, SecretManager secretManager) throws IOException {
        return UserGroupInformation.createRemoteUser(authorizedId);
    }

    public boolean shouldReLogin() throws IOException {
        return false;
    }

    public void reLogin() throws IOException, LoginException {
    }

    public boolean isProxyAllowed() {
        return true;
    }

    public String toString() {
        return this.simpleName.toUpperCase();
    }

    public boolean isNegotiable() {
        return false;
    }

    public boolean isSasl() {
        return false;
    }

    public String getProtocol() throws IOException {
        throw new AccessControlException("Server does not support SASL " + this.simpleName.toUpperCase());
    }

    public String getServerId() throws IOException {
        throw new AccessControlException("Server does not support SASL " + this.simpleName.toUpperCase());
    }

    public SaslClient createSaslClient(Map<String, Object> saslProperties) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support createSaslClient()");
    }

    public SaslServer createSaslServer(Server.Connection connection, Map<String, Object> saslProperties) throws IOException, InterruptedException {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support createSaslServer()");
    }
}

