/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeState;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;

public class VolumeProvisioningResults {
    private Map<VolumeId, VolumeProvisioningResult> resultMap = new HashMap<VolumeId, VolumeProvisioningResult>();

    public boolean isSuccess() {
        return !this.resultMap.isEmpty() && this.resultMap.values().stream().allMatch(subResult -> subResult.isSuccess());
    }

    public String getBriefMessage() {
        JsonObject obj = new JsonObject();
        obj.addProperty("TotalVolumes", (Number)this.resultMap.size());
        JsonObject failed = new JsonObject();
        for (VolumeProvisioningResult result : this.resultMap.values()) {
            if (result.isSuccess()) continue;
            failed.addProperty(result.getVolumeId().toString(), result.getVolumeState().name());
        }
        obj.add("failedVolumesStates", (JsonElement)failed);
        return obj.toString();
    }

    public void addResult(VolumeId volumeId, VolumeState state) {
        this.resultMap.put(volumeId, new VolumeProvisioningResult(volumeId, state));
    }

    static class VolumeProvisioningResult {
        private VolumeId volumeId;
        private VolumeState volumeState;
        private boolean success;

        VolumeProvisioningResult(VolumeId volumeId, VolumeState state) {
            this.volumeId = volumeId;
            this.volumeState = state;
            this.success = state == VolumeState.NODE_READY;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public VolumeId getVolumeId() {
            return this.volumeId;
        }

        public VolumeState getVolumeState() {
            return this.volumeState;
        }
    }
}

