/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleMergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectInMemoryOutput<K, V>
extends MapOutput<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectInMemoryOutput.class);
    private Configuration conf;
    private final DirectShuffleMergeManagerImpl<K, V> merger;
    private final byte[] memory;
    private BoundedByteArrayOutputStream byteStream;
    private final CompressionCodec codec;
    private final Decompressor decompressor;
    private boolean shouldCloseInput;

    public DirectInMemoryOutput(Configuration conf, TaskAttemptID mapId, DirectShuffleMergeManagerImpl<K, V> merger, int size, CompressionCodec codec, boolean primaryMapOutput) {
        super(mapId, (long)size, primaryMapOutput);
        this.conf = conf;
        this.merger = merger;
        this.codec = codec;
        this.byteStream = new BoundedByteArrayOutputStream(size);
        this.memory = this.byteStream.getBuffer();
        this.decompressor = codec != null ? CodecPool.getDecompressor((CompressionCodec)codec) : null;
    }

    public void shuffle(MapHost host, InputStream input, long mapOutputLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        if (this.codec != null) {
            this.decompressor.reset();
            input = this.codec.createInputStream(input, this.decompressor);
        }
        int bytesRead = 0;
        try {
            int n = IOUtils.wrappedReadForCompressedData((InputStream)input, (byte[])this.memory, (int)0, (int)this.memory.length);
            while (n > 0) {
                metrics.inputBytes((long)n);
                reporter.progress();
                n = IOUtils.wrappedReadForCompressedData((InputStream)input, (byte[])this.memory, (int)(bytesRead += n), (int)(this.memory.length - bytesRead));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read " + bytesRead + " bytes from map-output for " + this.getMapId());
            }
            if (this.shouldCloseInput) {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.info("Failed to shuffle from " + this.getMapId(), (Throwable)ioe);
            if (this.shouldCloseInput) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            }
            throw ioe;
        }
        finally {
            CodecPool.returnDecompressor((Decompressor)this.decompressor);
        }
        if ((long)bytesRead != mapOutputLength) {
            throw new IOException("Incomplete map output received for " + this.getMapId() + " from " + bytesRead + " instead of " + mapOutputLength + ")");
        }
        if (LOG.isDebugEnabled() && mapOutputLength > 0L) {
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(this.memory, 0, this.memory.length);
            LOG.debug("Rec #1 from " + this.getMapId() + " -> (" + WritableUtils.readVInt((DataInput)dib) + ", " + WritableUtils.readVInt((DataInput)dib) + ") from " + host.getHostName());
        }
    }

    public void commit() throws IOException {
        this.merger.closeInMemoryFile(this);
    }

    public void abort() {
        this.merger.unreserve(this.memory.length);
    }

    public String getDescription() {
        return "MEMORY";
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public BoundedByteArrayOutputStream getArrayStream() {
        return this.byteStream;
    }
}

