/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.MapOutputFileInfo;

public class MapRIFileInputStream
extends IFileInputStream {
    private MapOutputFileInfo info = null;
    boolean checkLength = false;

    public MapRIFileInputStream(InputStream in, long len, Configuration conf) throws IOException {
        this(in, len, true, conf);
    }

    public MapRIFileInputStream(InputStream in, long len, boolean checkLength, Configuration conf) throws IOException {
        super(in, len - (long)(in == null ? 0 : 16), conf);
        if (in != null) {
            this.checkLength = checkLength;
            this.info = new MapOutputFileInfo((FSDataInputStream)in, len, checkLength);
        }
    }

    public MapOutputFileInfo getMapOutputFileInfo() {
        return this.info;
    }

    public long getSize() {
        if (!this.checkLength) {
            return 0L;
        }
        if (this.info == null) {
            return super.getSize();
        }
        return 16L + super.getSize();
    }
}

