/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFixKerberosTicketOrder
extends KerberosSecurityTestcase {
    private String clientPrincipal = "client";
    private String server1Protocol = "server1";
    private String server2Protocol = "server2";
    private String host = "localhost";
    private String server1Principal = this.server1Protocol + "/" + this.host;
    private String server2Principal = this.server2Protocol + "/" + this.host;
    private File keytabFile;
    private Configuration conf = new Configuration();
    private Map<String, String> props;

    @Before
    public void setUp() throws Exception {
        this.keytabFile = new File(this.getWorkDir(), "keytab");
        this.getKdc().createPrincipal(this.keytabFile, new String[]{this.clientPrincipal, this.server1Principal, this.server2Principal});
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        System.setProperty("hadoop.login", "kerberos");
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        this.props = new HashMap<String, String>();
        this.props.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.AUTHENTICATION.saslQop);
    }

    @Test
    public void test() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.clientPrincipal, (String)this.keytabFile.getCanonicalPath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server1Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        });
        Subject subject = ugi.getSubject();
        for (KerberosTicket ticket : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!ticket.getServer().getName().startsWith("krbtgt")) continue;
            subject.getPrivateCredentials().remove(ticket);
            subject.getPrivateCredentials().add(ticket);
            break;
        }
        Assert.assertFalse((String)"The first ticket is still tgt, the implementation in jdk may have been changed, please reconsider the problem in HADOOP-13433", (boolean)subject.getPrivateCredentials().stream().filter(c -> c instanceof KerberosTicket).map(c -> ((KerberosTicket)c).getServer().getName()).findFirst().get().startsWith("krbtgt"));
        LambdaTestUtils.intercept(SaslException.class, () -> (Void)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server2Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        }));
        ugi.fixKerberosTicketOrder();
        Assert.assertTrue((String)"The first ticket is not tgt", (boolean)subject.getPrivateCredentials().stream().filter(c -> c instanceof KerberosTicket).map(c -> ((KerberosTicket)c).getServer().getName()).findFirst().get().startsWith("krbtgt"));
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server2Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        });
        Assert.assertTrue((String)("No service ticket for " + this.server2Protocol + " found"), (boolean)subject.getPrivateCredentials(KerberosTicket.class).stream().filter(t -> t.getServer().getName().startsWith(this.server2Protocol)).findAny().isPresent());
    }

    @Test
    public void testWithDestroyedTGT() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.clientPrincipal, (String)this.keytabFile.getCanonicalPath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server1Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        });
        Subject subject = ugi.getSubject();
        for (KerberosTicket ticket : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!ticket.getServer().getName().startsWith("krbtgt")) continue;
            ticket.destroy();
            break;
        }
        ugi.fixKerberosTicketOrder();
        Assert.assertFalse((String)"The first ticket is not tgt", (boolean)subject.getPrivateCredentials().stream().filter(c -> c instanceof KerberosTicket).map(c -> ((KerberosTicket)c).getServer().getName()).findFirst().isPresent());
        LambdaTestUtils.intercept(SaslException.class, () -> (Void)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server2Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        }));
        ugi.reloginFromKeytab();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestFixKerberosTicketOrder.this.clientPrincipal, TestFixKerberosTicketOrder.this.server2Protocol, TestFixKerberosTicketOrder.this.host, TestFixKerberosTicketOrder.this.props, null);
                client.evaluateChallenge(new byte[0]);
                client.dispose();
                return null;
            }
        });
        Assert.assertTrue((String)("No service ticket for " + this.server2Protocol + " found"), (boolean)subject.getPrivateCredentials(KerberosTicket.class).stream().filter(t -> t.getServer().getName().startsWith(this.server2Protocol)).findAny().isPresent());
    }
}

