/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.tools.dynamometer.AMOptions;
import org.apache.hadoop.tools.dynamometer.ApplicationMaster;
import org.apache.hadoop.tools.dynamometer.DynoConstants;
import org.apache.hadoop.tools.dynamometer.DynoInfraUtils;
import org.apache.hadoop.tools.dynamometer.DynoResource;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.WorkloadDriver;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditReplayMapper;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    public static final String APPNAME_ARG = "appname";
    public static final String APPNAME_DEFAULT = "DynamometerTest";
    public static final String QUEUE_ARG = "queue";
    public static final String QUEUE_DEFAULT = "default";
    public static final String TIMEOUT_ARG = "timeout";
    public static final String TIMEOUT_DEFAULT = "-1";
    public static final String HADOOP_VERSION_ARG = "hadoop_version";
    public static final String HADOOP_BINARY_PATH_ARG = "hadoop_binary_path";
    public static final String NAMENODE_SERVICERPC_ADDR_ARG = "namenode_servicerpc_addr";
    public static final String FS_IMAGE_DIR_ARG = "fs_image_dir";
    public static final String BLOCK_LIST_PATH_ARG = "block_list_path";
    public static final String CONF_PATH_ARG = "conf_path";
    public static final String MASTER_VCORES_ARG = "master_vcores";
    public static final String MASTER_VCORES_DEFAULT = "1";
    public static final String MASTER_MEMORY_MB_ARG = "master_memory_mb";
    public static final String MASTER_MEMORY_MB_DEFAULT = "2048";
    public static final String TOKEN_FILE_LOCATION_ARG = "token_file_location";
    public static final String WORKLOAD_REPLAY_ENABLE_ARG = "workload_replay_enable";
    public static final String WORKLOAD_INPUT_PATH_ARG = "workload_input_path";
    public static final String WORKLOAD_OUTPUT_PATH_ARG = "workload_output_path";
    public static final String WORKLOAD_THREADS_PER_MAPPER_ARG = "workload_threads_per_mapper";
    public static final String WORKLOAD_START_DELAY_ARG = "workload_start_delay";
    public static final String WORKLOAD_RATE_FACTOR_ARG = "workload_rate_factor";
    public static final String WORKLOAD_RATE_FACTOR_DEFAULT = "1.0";
    public static final String WORKLOAD_CONFIG_ARG = "workload_config";
    private static final String[] ARCHIVE_FILE_TYPES = new String[]{".zip", ".tar", ".tgz", ".tar.gz"};
    private static final String START_SCRIPT_LOCATION = Client.class.getClassLoader().getResource(DynoConstants.START_SCRIPT.getResourcePath()).toString();
    private YarnClient yarnClient;
    private String appName = "";
    private String amQueue = "";
    private int amMemory = 10;
    private int amVCores = 1;
    private final String[] dependencyJars;
    private String hadoopBinary = "";
    private String confPath = "";
    private String blockListPath = "";
    private String fsImagePath = "";
    private String fsImageMD5Path = "";
    private String versionFilePath = "";
    private String remoteNameNodeRpcAddress = "";
    private boolean launchNameNode;
    private String tokenFileLocation;
    private AMOptions amOptions;
    private ApplicationId infraAppId;
    private volatile YarnApplicationState infraAppState = YarnApplicationState.NEW;
    private volatile JobStatus.State workloadAppState = JobStatus.State.PREP;
    private int numTotalDataNodes;
    private boolean launchWorkloadJob = false;
    private volatile Job workloadJob;
    private String workloadInputPath = "";
    private String workloadOutputPath = "";
    private int workloadThreadsPerMapper;
    private long workloadStartDelayMs;
    private double workloadRateFactor = 0.0;
    private Map<String, String> workloadExtraConfigs;
    private final long clientStartTime = System.currentTimeMillis();
    private long clientTimeout;
    private Options opts;

    public static void main(String[] args) throws Exception {
        Client client = new Client(ClassUtil.findContainingJar(ApplicationMaster.class));
        System.exit(ToolRunner.run((Configuration)new YarnConfiguration(), (Tool)client, (String[])args));
    }

    public int run(String[] args) {
        boolean result;
        try {
            LOG.info("Initializing Client");
            try {
                boolean doRun = this.init(args);
                if (!doRun) {
                    return 0;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
                this.printUsage();
                return -1;
            }
            result = this.run();
        }
        catch (Throwable t) {
            LOG.error("Error running Client", t);
            return 1;
        }
        if (result) {
            LOG.info("Application completed successfully");
            return 0;
        }
        LOG.error("Application failed to complete successfully");
        return 2;
    }

    public Client(String ... dependencyJars) {
        Preconditions.checkArgument((dependencyJars != null && dependencyJars.length > 0 ? 1 : 0) != 0, (Object)"Must specify at least one dependency JAR for the ApplicationMaster");
        this.dependencyJars = dependencyJars;
        this.opts = new Options();
        this.opts.addOption(APPNAME_ARG, true, "Application Name. (default 'DynamometerTest')");
        this.opts.addOption(QUEUE_ARG, true, "RM Queue in which this application is to be submitted (default 'default')");
        this.opts.addOption(TIMEOUT_ARG, true, "Application timeout in milliseconds (default -1 = unlimited)");
        this.opts.addOption(MASTER_MEMORY_MB_ARG, true, "Amount of memory in MB to be requested to run the application master (default 2048)");
        this.opts.addOption(MASTER_VCORES_ARG, true, "Amount of virtual cores to be requested to run the application master (default 1)");
        this.opts.addOption(CONF_PATH_ARG, true, "Location of the directory or archive containing the Hadoop configuration. If this is already on a remote FS, will save the copy step, but must be an archive file. This must have the standard Hadoop conf layout containing e.g. etc/hadoop/*-site.xml");
        this.opts.addOption(BLOCK_LIST_PATH_ARG, true, "Location on HDFS of the files containing the DN block lists.");
        this.opts.addOption(FS_IMAGE_DIR_ARG, true, "Location of the directory containing, at minimum, the VERSION file for the namenode. If running the namenode within YARN (namenode_info_path is not specified), this must also include the fsimage file and its md5 hash with names conforming to: `fsimage_XXXXXXXX[.md5]`.");
        for (String option : new String[]{CONF_PATH_ARG, BLOCK_LIST_PATH_ARG, FS_IMAGE_DIR_ARG}) {
            this.opts.getOption(option).setRequired(true);
        }
        OptionGroup hadoopBinaryGroup = new OptionGroup();
        hadoopBinaryGroup.addOption(new Option(HADOOP_BINARY_PATH_ARG, true, "Location of Hadoop binary to be deployed (archive). One of this or hadoop_version is required."));
        hadoopBinaryGroup.addOption(new Option(HADOOP_VERSION_ARG, true, "Version of Hadoop (like '2.7.4' or '3.0.0-beta1') for which to download a binary. If this is specified, a Hadoop tarball will be downloaded from an Apache mirror. By default the Berkeley OCF mirror is used; specify dyno.apache-mirror as a configuration or system property to change which mirror is used. The tarball will be downloaded to the working directory. One of this or hadoop_binary_path is required."));
        hadoopBinaryGroup.setRequired(true);
        this.opts.addOptionGroup(hadoopBinaryGroup);
        this.opts.addOption(NAMENODE_SERVICERPC_ADDR_ARG, true, "Specify this option to run the NameNode external to YARN. This is the service RPC address of the NameNode, e.g. localhost:9020.");
        this.opts.addOption(TOKEN_FILE_LOCATION_ARG, true, "If specified, this file will be used as the delegation token(s) for the launched containers. Otherwise, the delegation token(s) for the default FileSystem will be used.");
        AMOptions.setOptions(this.opts);
        this.opts.addOption(WORKLOAD_REPLAY_ENABLE_ARG, false, "If specified, this client will additionally launch the workload replay job to replay audit logs against the HDFS cluster which is started.");
        this.opts.addOption(WORKLOAD_INPUT_PATH_ARG, true, "Location of the audit traces to replay (Required for workload)");
        this.opts.addOption(WORKLOAD_OUTPUT_PATH_ARG, true, "Location of the metrics output (Required for workload)");
        this.opts.addOption(WORKLOAD_THREADS_PER_MAPPER_ARG, true, "Number of threads per mapper to use to replay the workload. (default 1)");
        this.opts.addOption(WORKLOAD_START_DELAY_ARG, true, "Delay between launching the Workload MR job and starting the audit logic replay; this is used in an attempt to allow all mappers to be launched before any of them start replaying. Workloads with more mappers may need a longer delay to get all of the containers allocated. Human-readable units accepted (e.g. 30s, 10m). (default 1m)");
        this.opts.addOption(WORKLOAD_RATE_FACTOR_ARG, true, "Rate factor (multiplicative speed factor) to apply to workload replay (Default 1.0)");
        this.opts.addOption(WORKLOAD_CONFIG_ARG, true, "Additional configurations to pass only to the workload job. This can be used multiple times and should be specified as a key=value pair, e.g. '-workload_config conf.one=val1 -workload_config conf.two=val2'");
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("Client", this.opts);
    }

    public boolean init(String[] args) throws ParseException, IOException {
        List<String> list = Arrays.asList(args);
        if (list.contains("-h") || list.contains("--help")) {
            this.printUsage();
            return false;
        }
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(this.opts, args);
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(this.getConf());
        LOG.info("Starting with arguments: [\"{}\"]", (Object)Joiner.on((String)"\" \"").join((Object[])args));
        Path fsImageDir = new Path(commandLine.getOptionValue(FS_IMAGE_DIR_ARG, ""));
        this.versionFilePath = new Path(fsImageDir, "VERSION").toString();
        if (commandLine.hasOption(NAMENODE_SERVICERPC_ADDR_ARG)) {
            this.launchNameNode = false;
            this.remoteNameNodeRpcAddress = commandLine.getOptionValue(NAMENODE_SERVICERPC_ADDR_ARG);
        } else {
            this.launchNameNode = true;
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.getConf());
            FileSystem fsImageFS = (fsImageDir = fsImageDir.makeQualified(localFS.getUri(), localFS.getWorkingDirectory())).getFileSystem(this.getConf());
            FileStatus[] fileStatusArray = fsImageFS.listStatus(fsImageDir, path -> path.getName().matches("^fsimage_(\\d)+$"));
            if (fileStatusArray.length != 1) {
                throw new IllegalArgumentException("Must be exactly one fsimage file present in fs_image_dir");
            }
            this.fsImagePath = fileStatusArray[0].getPath().toString();
            this.fsImageMD5Path = fileStatusArray[0].getPath().suffix(".md5").toString();
        }
        if (this.amMemory < 0) {
            throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
        }
        if (this.amVCores < 0) {
            throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
        }
        this.appName = commandLine.getOptionValue(APPNAME_ARG, APPNAME_DEFAULT);
        this.amQueue = commandLine.getOptionValue(QUEUE_ARG, QUEUE_DEFAULT);
        this.amMemory = Integer.parseInt(commandLine.getOptionValue(MASTER_MEMORY_MB_ARG, MASTER_MEMORY_MB_DEFAULT));
        this.amVCores = Integer.parseInt(commandLine.getOptionValue(MASTER_VCORES_ARG, MASTER_VCORES_DEFAULT));
        this.confPath = commandLine.getOptionValue(CONF_PATH_ARG);
        this.blockListPath = commandLine.getOptionValue(BLOCK_LIST_PATH_ARG);
        this.hadoopBinary = commandLine.hasOption(HADOOP_BINARY_PATH_ARG) ? commandLine.getOptionValue(HADOOP_BINARY_PATH_ARG) : DynoInfraUtils.fetchHadoopTarball(new File(".").getAbsoluteFile(), commandLine.getOptionValue(HADOOP_VERSION_ARG), this.getConf(), LOG).toString();
        this.amOptions = AMOptions.initFromParser(commandLine);
        this.clientTimeout = Integer.parseInt(commandLine.getOptionValue(TIMEOUT_ARG, TIMEOUT_DEFAULT));
        this.tokenFileLocation = commandLine.getOptionValue(TOKEN_FILE_LOCATION_ARG);
        this.amOptions.verify();
        Path blockPath = new Path(this.blockListPath);
        FileSystem blockListFS = blockPath.getFileSystem(this.getConf());
        if (blockListFS.getUri().equals(FileSystem.getLocal((Configuration)this.getConf()).getUri()) || !blockListFS.exists(blockPath)) {
            throw new IllegalArgumentException("block list path must already exist on remote fs!");
        }
        this.numTotalDataNodes = blockListFS.listStatus(blockPath, DynoConstants.BLOCK_LIST_FILE_FILTER).length;
        if (commandLine.hasOption(WORKLOAD_REPLAY_ENABLE_ARG)) {
            if (!commandLine.hasOption(WORKLOAD_INPUT_PATH_ARG) || !commandLine.hasOption(WORKLOAD_START_DELAY_ARG)) {
                throw new IllegalArgumentException("workload_replay_enable was specified; must include all required workload_ parameters.");
            }
            this.launchWorkloadJob = true;
            this.workloadInputPath = commandLine.getOptionValue(WORKLOAD_INPUT_PATH_ARG);
            this.workloadOutputPath = commandLine.getOptionValue(WORKLOAD_OUTPUT_PATH_ARG);
            this.workloadThreadsPerMapper = Integer.parseInt(commandLine.getOptionValue(WORKLOAD_THREADS_PER_MAPPER_ARG, String.valueOf(1)));
            this.workloadRateFactor = Double.parseDouble(commandLine.getOptionValue(WORKLOAD_RATE_FACTOR_ARG, WORKLOAD_RATE_FACTOR_DEFAULT));
            this.workloadExtraConfigs = new HashMap<String, String>();
            if (commandLine.getOptionValues(WORKLOAD_CONFIG_ARG) != null) {
                for (String string : commandLine.getOptionValues(WORKLOAD_CONFIG_ARG)) {
                    Iterator kvPair = Splitter.on((String)"=").trimResults().split((CharSequence)string).iterator();
                    this.workloadExtraConfigs.put((String)kvPair.next(), (String)kvPair.next());
                }
            }
            String string = commandLine.getOptionValue(WORKLOAD_START_DELAY_ARG, "1m");
            this.getConf().set("___temp___", string);
            this.workloadStartDelayMs = this.getConf().getTimeDuration("___temp___", 0L, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    public boolean run() throws IOException, YarnException {
        LOG.info("Running Client");
        this.yarnClient.start();
        YarnClusterMetrics clusterMetrics = this.yarnClient.getYarnClusterMetrics();
        LOG.info("Got Cluster metric info from ASM, numNodeManagers={}", (Object)clusterMetrics.getNumNodeManagers());
        QueueInfo queueInfo = this.yarnClient.getQueueInfo(this.amQueue);
        LOG.info("Queue info: queueName={}, queueCurrentCapacity={}, queueMaxCapacity={}, queueApplicationCount={}, queueChildQueueCount={}", new Object[]{queueInfo.getQueueName(), Float.valueOf(queueInfo.getCurrentCapacity()), Float.valueOf(queueInfo.getMaximumCapacity()), queueInfo.getApplications().size(), queueInfo.getChildQueues().size()});
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        long maxMem = appResponse.getMaximumResourceCapability().getMemorySize();
        LOG.info("Max mem capabililty of resources in this cluster " + maxMem);
        int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
        LOG.info("Max virtual cores capabililty of resources in this cluster {}", (Object)maxVCores);
        if ((long)this.amMemory > maxMem || this.amMemory < 0 || this.amVCores > maxVCores || this.amVCores < 0) {
            throw new IllegalArgumentException("Invalid AM memory or vcores: memory=" + this.amMemory + ", vcores=" + this.amVCores);
        }
        this.amOptions.verify(maxMem, maxVCores);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        this.infraAppId = appContext.getApplicationId();
        appContext.setApplicationName(this.appName);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.VIEW_APP, this.getConf().get("mapreduce.job.acl-view-job", " "));
        amContainer.setApplicationACLs(acls);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        fs.mkdirs(Client.getRemoteStoragePath(this.getConf(), this.infraAppId));
        Map<String, String> env = this.setupRemoteResourcesGetEnv();
        amContainer.setEnvironment(env);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        LocalResource scRsrc = LocalResource.newInstance((URL)URL.fromPath((Path)DynoConstants.DYNO_DEPENDENCIES.getPath(env)), (LocalResourceType)LocalResourceType.ARCHIVE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)DynoConstants.DYNO_DEPENDENCIES.getLength(env), (long)DynoConstants.DYNO_DEPENDENCIES.getTimestamp(env));
        localResources.put(DynoConstants.DYNO_DEPENDENCIES.getResourcePath(), scRsrc);
        amContainer.setLocalResources(localResources);
        amContainer.setCommands(this.getAMCommand());
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemorySize((long)this.amMemory);
        capability.setVirtualCores(this.amVCores);
        appContext.setResource(capability);
        if (UserGroupInformation.isSecurityEnabled()) {
            ByteBuffer fsTokens;
            if (this.tokenFileLocation != null) {
                fsTokens = ByteBuffer.wrap(Files.readAllBytes(Paths.get(this.tokenFileLocation, new String[0])));
            } else {
                Credentials credentials = new Credentials();
                String tokenRenewer = this.getConf().get("yarn.resourcemanager.principal");
                if (tokenRenewer == null || tokenRenewer.length() == 0) {
                    throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
                }
                Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
                if (tokens != null) {
                    for (Token token : tokens) {
                        LOG.info("Got dt for " + fs.getUri() + "; " + token);
                    }
                }
                DataOutputBuffer dob = new DataOutputBuffer();
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
                fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            }
            amContainer.setTokens(fsTokens);
        }
        appContext.setAMContainerSpec(amContainer);
        appContext.setQueue(this.amQueue);
        LOG.info("Submitting application to RM");
        this.yarnClient.submitApplication(appContext);
        return this.monitorInfraApplication();
    }

    private Map<String, String> setupRemoteResourcesGetEnv() throws IOException {
        LOG.info("Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.launchNameNode) {
            this.setupRemoteResource(this.infraAppId, DynoConstants.FS_IMAGE, env, this.fsImagePath);
            this.setupRemoteResource(this.infraAppId, DynoConstants.FS_IMAGE_MD5, env, this.fsImageMD5Path);
        } else {
            env.put("REMOTE_NN_RPC_ADDR", this.remoteNameNodeRpcAddress);
        }
        this.setupRemoteResource(this.infraAppId, DynoConstants.VERSION, env, this.versionFilePath);
        this.setupRemoteResource(this.infraAppId, DynoConstants.CONF_ZIP, env, this.confPath);
        this.setupRemoteResource(this.infraAppId, DynoConstants.START_SCRIPT, env, START_SCRIPT_LOCATION);
        this.setupRemoteResource(this.infraAppId, DynoConstants.HADOOP_BINARY, env, this.hadoopBinary);
        this.setupRemoteResource(this.infraAppId, DynoConstants.DYNO_DEPENDENCIES, env, this.dependencyJars);
        env.put("BLOCK_ZIP_PATH", this.blockListPath);
        env.put("JOB_ACL_VIEW", this.getConf().get("mapreduce.job.acl-view-job", " "));
        env.put("REMOTE_STORAGE_PATH", Client.getRemoteStoragePath(this.getConf(), this.infraAppId).toString());
        env.put(ApplicationConstants.Environment.CLASSPATH.key(), this.getAMClassPathEnv());
        return env;
    }

    private String getAMClassPathEnv() {
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$()).append("<CPS>").append("./").append(DynoConstants.DYNO_DEPENDENCIES.getResourcePath()).append("/*");
        for (String c : this.getConf().getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(c.trim());
        }
        classPathEnv.append("<CPS>").append("./log4j.properties");
        if (this.getConf().getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        return classPathEnv.toString();
    }

    private List<String> getAMCommand() {
        ArrayList<String> vargs = new ArrayList<String>();
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        long appMasterHeapSize = Math.round((double)this.amMemory * 0.85);
        vargs.add("-Xmx" + appMasterHeapSize + "m");
        vargs.add(ApplicationMaster.class.getCanonicalName());
        this.amOptions.addToVargs(vargs);
        vargs.add("1><LOG_DIR>/stdout");
        vargs.add("2><LOG_DIR>/stderr");
        LOG.info("Completed setting up app master command: " + vargs);
        return Lists.newArrayList((Object[])new String[]{Joiner.on((String)" ").join(vargs)});
    }

    private void setupRemoteResource(ApplicationId appId, DynoResource resource, Map<String, String> env, String ... srcPaths) throws IOException {
        FileStatus remoteFileStatus;
        Path dstPath;
        Preconditions.checkArgument((srcPaths.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least one source path");
        Preconditions.checkArgument((resource.getType() == LocalResourceType.ARCHIVE || srcPaths.length == 1 ? 1 : 0) != 0, (Object)"Can only specify multiple source paths if using an ARCHIVE type");
        List srcURIs = Arrays.stream(srcPaths).map(URI::create).collect(Collectors.toList());
        Set srcSchemes = srcURIs.stream().map(URI::getScheme).collect(Collectors.toSet());
        Preconditions.checkArgument((srcSchemes.size() == 1 ? 1 : 0) != 0, (Object)"All source paths must have the same scheme");
        String srcScheme = (String)srcSchemes.iterator().next();
        String srcPathString = "[" + Joiner.on((String)",").join((Object[])srcPaths) + "]";
        if (srcScheme == null || srcScheme.equals(FileSystem.getLocal((Configuration)this.getConf()).getScheme()) || srcScheme.equals("jar")) {
            FileSystem remoteFS;
            block31: {
                boolean shouldArchive;
                ArrayList srcFiles = srcURIs.stream().map(URI::getSchemeSpecificPart).map(File::new).collect(Collectors.toList());
                Path dstPathBase = Client.getRemoteStoragePath(this.getConf(), appId);
                boolean bl = shouldArchive = srcFiles.size() > 1 || ((File)srcFiles.get(0)).isDirectory() || resource.getType() == LocalResourceType.ARCHIVE && Arrays.stream(ARCHIVE_FILE_TYPES).noneMatch(suffix -> ((File)srcFiles.get(0)).getName().endsWith((String)suffix));
                if (shouldArchive) {
                    if ("jar".equals(srcScheme)) {
                        throw new IllegalArgumentException(String.format("Resources in JARs can't be zipped; resource %s is ARCHIVE and src is: %s", resource.getResourcePath(), srcPathString));
                    }
                    if (resource.getType() != LocalResourceType.ARCHIVE) {
                        throw new IllegalArgumentException(String.format("Resource type is %s but srcPaths were: %s", resource.getType(), srcPathString));
                    }
                    dstPath = new Path(dstPathBase, resource.getResourcePath()).suffix(".zip");
                } else {
                    dstPath = new Path(dstPathBase, ((File)srcFiles.get(0)).getName());
                }
                remoteFS = dstPath.getFileSystem(this.getConf());
                LOG.info("Uploading resource " + resource + " from " + srcPathString + " to " + dstPath);
                try (FSDataOutputStream outputStream = remoteFS.create(dstPath, true);){
                    if ("jar".equals(srcScheme)) {
                        try (InputStream inputStream = new java.net.URL(srcPaths[0]).openStream();){
                            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (Configuration)this.getConf());
                            break block31;
                        }
                    }
                    if (shouldArchive) {
                        ArrayList filesToZip;
                        if (srcFiles.size() == 1 && ((File)srcFiles.get(0)).isDirectory()) {
                            Object[] childFiles = ((File)srcFiles.get(0)).listFiles();
                            if (childFiles == null || childFiles.length == 0) {
                                throw new IllegalArgumentException("Specified a directory to archive with no contents");
                            }
                            filesToZip = Lists.newArrayList((Object[])childFiles);
                        } else {
                            filesToZip = srcFiles;
                        }
                        ZipOutputStream zout = new ZipOutputStream((OutputStream)outputStream);
                        for (File fileToZip : filesToZip) {
                            this.addFileToZipRecursively(fileToZip.getParentFile(), fileToZip, zout);
                        }
                        zout.close();
                        break block31;
                    }
                    try (FileInputStream inputStream = new FileInputStream((File)srcFiles.get(0));){
                        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (Configuration)this.getConf());
                    }
                }
            }
            remoteFileStatus = remoteFS.getFileStatus(dstPath);
        } else {
            if (srcPaths.length > 1) {
                throw new IllegalArgumentException("If resource is on remote, must be a single file: " + srcPathString);
            }
            LOG.info("Using resource {} directly from current location: {}", (Object)resource, (Object)srcPaths[0]);
            dstPath = new Path(srcPaths[0]);
            remoteFileStatus = FileSystem.get((URI)dstPath.toUri(), (Configuration)this.getConf()).getFileStatus(dstPath);
            if (remoteFileStatus.isDirectory()) {
                throw new IllegalArgumentException("If resource is on remote filesystem, must be a file: " + srcPaths[0]);
            }
        }
        env.put(resource.getLocationEnvVar(), dstPath.toString());
        env.put(resource.getTimestampEnvVar(), String.valueOf(remoteFileStatus.getModificationTime()));
        env.put(resource.getLengthEnvVar(), String.valueOf(remoteFileStatus.getLen()));
    }

    private static Path getRemoteStoragePath(Configuration conf, ApplicationId appId) throws IOException {
        FileSystem remoteFS = FileSystem.get((Configuration)conf);
        return remoteFS.makeQualified(new Path(remoteFS.getHomeDirectory(), ".dynamometer/" + appId));
    }

    private void addFileToZipRecursively(File root, File file, ZipOutputStream out) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            String relativePath = file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
            try (FileInputStream in = new FileInputStream(file.getAbsolutePath());){
                out.putNextEntry(new ZipEntry(relativePath));
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)this.getConf(), (boolean)false);
                out.closeEntry();
            }
            catch (FileNotFoundException fnfe) {
                LOG.warn("Skipping file; it is a symlink with a nonexistent target: {}", (Object)file);
            }
        } else {
            for (File containedFile : files) {
                this.addFileToZipRecursively(root, containedFile, out);
            }
        }
    }

    private boolean monitorInfraApplication() throws YarnException, IOException {
        boolean loggedApplicationInfo = false;
        boolean success = false;
        Thread namenodeMonitoringThread = new Thread(() -> {
            Supplier<Boolean> exitCritera = () -> Apps.isApplicationFinalState((YarnApplicationState)this.infraAppState);
            Optional<Object> namenodeProperties = Optional.empty();
            while (!exitCritera.get().booleanValue()) {
                try {
                    if (!namenodeProperties.isPresent()) {
                        namenodeProperties = DynoInfraUtils.waitForAndGetNameNodeProperties(exitCritera, this.getConf(), this.getNameNodeInfoPath(), LOG);
                        if (!namenodeProperties.isPresent()) break;
                        Properties props = (Properties)namenodeProperties.get();
                        LOG.info("NameNode can be reached via HDFS at: {}", (Object)DynoInfraUtils.getNameNodeHdfsUri(props));
                        LOG.info("NameNode web UI available at: {}", (Object)DynoInfraUtils.getNameNodeWebUri(props));
                        LOG.info("NameNode can be tracked at: {}", (Object)DynoInfraUtils.getNameNodeTrackingUri(props));
                    }
                    DynoInfraUtils.waitForNameNodeStartup((Properties)namenodeProperties.get(), exitCritera, LOG);
                    DynoInfraUtils.waitForNameNodeReadiness((Properties)namenodeProperties.get(), this.numTotalDataNodes, false, exitCritera, this.getConf(), LOG);
                    break;
                }
                catch (IOException ioe) {
                    LOG.error("Unexpected exception while waiting for NameNode readiness", (Throwable)ioe);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
            if (!Apps.isApplicationFinalState((YarnApplicationState)this.infraAppState) && this.launchWorkloadJob) {
                this.launchAndMonitorWorkloadDriver((Properties)namenodeProperties.get());
            }
        });
        if (this.launchNameNode) {
            namenodeMonitoringThread.start();
        }
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread sleep in monitoring loop interrupted");
            }
            ApplicationReport report = this.yarnClient.getApplicationReport(this.infraAppId);
            if (report.getTrackingUrl() != null && !loggedApplicationInfo) {
                loggedApplicationInfo = true;
                LOG.info("Track the application at: " + report.getTrackingUrl());
                LOG.info("Kill the application using: yarn application -kill " + report.getApplicationId());
            }
            LOG.debug("Got application report from ASM for: appId={}, clientToAMToken={}, appDiagnostics={}, appMasterHost={}, appQueue={}, appMasterRpcPort={}, appStartTime={}, yarnAppState={}, distributedFinalState={}, appTrackingUrl={}, appUser={}", new Object[]{this.infraAppId.getId(), report.getClientToAMToken(), report.getDiagnostics(), report.getHost(), report.getQueue(), report.getRpcPort(), report.getStartTime(), report.getYarnApplicationState(), report.getFinalApplicationStatus(), report.getTrackingUrl(), report.getUser()});
            this.infraAppState = report.getYarnApplicationState();
            if (this.infraAppState == YarnApplicationState.KILLED) {
                if (!this.launchWorkloadJob) {
                    success = true;
                } else if (this.workloadJob == null) {
                    LOG.error("Infra app was killed before workload job was launched.");
                } else if (!this.workloadJob.isComplete()) {
                    LOG.error("Infra app was killed before workload job completed.");
                } else if (this.workloadJob.isSuccessful()) {
                    success = true;
                }
                LOG.info("Infra app was killed; exiting from client.");
                break;
            }
            if (this.infraAppState == YarnApplicationState.FINISHED || this.infraAppState == YarnApplicationState.FAILED) {
                LOG.info("Infra app exited unexpectedly. YarnState=" + this.infraAppState.toString() + ". Exiting from client.");
                break;
            }
            if (this.clientTimeout != -1L && System.currentTimeMillis() > this.clientStartTime + this.clientTimeout) {
                LOG.info("Reached client specified timeout of {} ms for application. Killing application", (Object)this.clientTimeout);
                this.attemptCleanup();
                break;
            }
            if (!Client.isCompleted(this.workloadAppState)) continue;
            LOG.info("Killing infrastructure app");
            try {
                this.forceKillApplication(this.infraAppId);
            }
            catch (IOException | YarnException e) {
                LOG.error("Exception encountered while killing infra app", e);
            }
        }
        if (this.launchNameNode) {
            try {
                namenodeMonitoringThread.interrupt();
                namenodeMonitoringThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted while joining workload job thread; continuing to cleanup.");
            }
        }
        this.attemptCleanup();
        return success;
    }

    @VisibleForTesting
    Path getNameNodeInfoPath() throws IOException {
        return new Path(Client.getRemoteStoragePath(this.getConf(), this.infraAppId), "nn_info.prop");
    }

    private void launchAndMonitorWorkloadDriver(Properties nameNodeProperties) {
        URI nameNodeURI = DynoInfraUtils.getNameNodeHdfsUri(nameNodeProperties);
        LOG.info("Launching workload job using input path: " + this.workloadInputPath);
        try {
            long workloadStartTime = System.currentTimeMillis() + this.workloadStartDelayMs;
            Configuration workloadConf = new Configuration(this.getConf());
            workloadConf.set("auditreplay.input-path", this.workloadInputPath);
            workloadConf.set("auditreplay.output-path", this.workloadOutputPath);
            workloadConf.setInt("auditreplay.num-threads", this.workloadThreadsPerMapper);
            workloadConf.setDouble("auditreplay.rate-factor", this.workloadRateFactor);
            for (Map.Entry<String, String> configPair : this.workloadExtraConfigs.entrySet()) {
                workloadConf.set(configPair.getKey(), configPair.getValue());
            }
            this.workloadJob = WorkloadDriver.getJobForSubmission((Configuration)workloadConf, (String)nameNodeURI.toString(), (long)workloadStartTime, AuditReplayMapper.class);
            this.workloadJob.submit();
            while (!Apps.isApplicationFinalState((YarnApplicationState)this.infraAppState) && !Client.isCompleted(this.workloadAppState)) {
                this.workloadJob.monitorAndPrintJob();
                Thread.sleep(5000L);
                this.workloadAppState = this.workloadJob.getJobState();
            }
            if (Client.isCompleted(this.workloadAppState)) {
                LOG.info("Workload job completed successfully!");
            } else {
                LOG.warn("Workload job failed.");
            }
        }
        catch (Exception e) {
            LOG.error("Exception encountered while running workload job", (Throwable)e);
        }
    }

    public void attemptCleanup() {
        LOG.info("Attempting to clean up remaining running applications.");
        if (this.workloadJob != null) {
            try {
                this.workloadAppState = this.workloadJob.getJobState();
            }
            catch (IOException ioe) {
                LOG.warn("Unable to fetch completion status of workload job. Will proceed to attempt to kill it.", (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!Client.isCompleted(this.workloadAppState)) {
                try {
                    LOG.info("Attempting to kill workload app: {}", (Object)this.workloadJob.getJobID());
                    this.workloadJob.killJob();
                    LOG.info("Killed workload app");
                }
                catch (IOException ioe) {
                    LOG.error("Unable to kill workload app ({})", (Object)this.workloadJob.getJobID(), (Object)ioe);
                }
            }
        }
        if (this.infraAppId != null && !Apps.isApplicationFinalState((YarnApplicationState)this.infraAppState)) {
            try {
                LOG.info("Attempting to kill infrastructure app: " + this.infraAppId);
                this.forceKillApplication(this.infraAppId);
                LOG.info("Killed infrastructure app");
            }
            catch (IOException | YarnException e) {
                LOG.error("Unable to kill infrastructure app ({})", (Object)this.infraAppId, (Object)e);
            }
        }
    }

    private static boolean isCompleted(JobStatus.State state) {
        return state == JobStatus.State.SUCCEEDED || state == JobStatus.State.FAILED || state == JobStatus.State.KILLED;
    }

    private void forceKillApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    @VisibleForTesting
    Job getWorkloadJob() {
        return this.workloadJob;
    }
}

