/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.config;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.hadoop.shaded.org.ehcache.config.Builder;
import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.EvictionAdvisor;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePools;
import org.apache.hadoop.shaded.org.ehcache.expiry.ExpiryPolicy;
import org.apache.hadoop.shaded.org.ehcache.spi.copy.Copier;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.ResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.spi.serialization.Serializer;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;

public interface FluentCacheConfigurationBuilder<K, V, B extends FluentCacheConfigurationBuilder<K, V, ?>>
extends Builder<CacheConfiguration<K, V>> {
    @Override
    public CacheConfiguration<K, V> build();

    default public <C extends ServiceConfiguration<?, ?>> C getService(Class<C> configurationType) throws IllegalArgumentException {
        Collection<C> services = this.getServices(configurationType);
        switch (services.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (C)((ServiceConfiguration)services.iterator().next());
            }
        }
        throw new IllegalArgumentException(configurationType + " does not identify a unique service configuration: " + services);
    }

    public <C extends ServiceConfiguration<?, ?>> Collection<C> getServices(Class<C> var1);

    public B withService(ServiceConfiguration<?, ?> var1);

    default public B withService(Builder<? extends ServiceConfiguration<?, ?>> builder) {
        return this.withService(builder.build());
    }

    default public B withoutServices(Class<? extends ServiceConfiguration<?, ?>> clazz) {
        return this.withoutServices(clazz, c -> true);
    }

    public <C extends ServiceConfiguration<?, ?>> B withoutServices(Class<C> var1, Predicate<? super C> var2);

    public <R, C extends ServiceConfiguration<?, R>> B updateServices(Class<C> var1, UnaryOperator<R> var2) throws IllegalStateException;

    public B withEvictionAdvisor(EvictionAdvisor<? super K, ? super V> var1);

    public B withClassLoader(ClassLoader var1);

    public B withDefaultClassLoader();

    public B withResourcePools(ResourcePools var1);

    default public B withResourcePools(Builder<? extends ResourcePools> builder) {
        return this.withResourcePools(builder.build());
    }

    public B updateResourcePools(UnaryOperator<ResourcePools> var1);

    public B withExpiry(ExpiryPolicy<? super K, ? super V> var1);

    public B withLoaderWriter(CacheLoaderWriter<K, V> var1);

    public B withLoaderWriter(Class<CacheLoaderWriter<K, V>> var1, Object ... var2);

    public B withoutLoaderWriter();

    public B withResilienceStrategy(ResilienceStrategy<K, V> var1);

    public B withResilienceStrategy(Class<? extends ResilienceStrategy> var1, Object ... var2);

    public B withDefaultResilienceStrategy();

    public B withKeySerializingCopier();

    public B withValueSerializingCopier();

    public B withKeyCopier(Copier<K> var1);

    public B withKeyCopier(Class<? extends Copier<K>> var1);

    public B withoutKeyCopier();

    public B withValueCopier(Copier<V> var1);

    public B withValueCopier(Class<? extends Copier<V>> var1);

    public B withoutValueCopier();

    public B withKeySerializer(Serializer<K> var1);

    public B withKeySerializer(Class<? extends Serializer<K>> var1);

    public B withDefaultKeySerializer();

    public B withValueSerializer(Serializer<V> var1);

    public B withValueSerializer(Class<? extends Serializer<V>> var1);

    public B withDefaultValueSerializer();
}

