/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.ConflictResolutionMode;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import org.apache.commons.text.WordUtils;

public class ConflictResolutionPolicy
extends JsonSerializable {
    public static ConflictResolutionPolicy createLastWriterWinsPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LastWriterWins);
        return policy;
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy(String conflictResolutionPath) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LastWriterWins);
        if (conflictResolutionPath != null) {
            policy.setConflictResolutionPath(conflictResolutionPath);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String conflictResolutionSprocName) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.Custom);
        if (conflictResolutionSprocName != null) {
            policy.setConflictResolutionProcedure(conflictResolutionSprocName);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.Custom);
        return policy;
    }

    ConflictResolutionPolicy() {
    }

    public ConflictResolutionPolicy(String jsonString) {
        super(jsonString);
    }

    public ConflictResolutionMode getConflictResolutionMode() {
        String strValue = super.getString("mode");
        if (!Strings.isNullOrEmpty(strValue)) {
            try {
                return ConflictResolutionMode.valueOf(WordUtils.capitalize((String)super.getString("mode")));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("Invalid ConflictResolutionMode value {}.", (Object)super.getString("mode"));
                return ConflictResolutionMode.Invalid;
            }
        }
        return ConflictResolutionMode.Invalid;
    }

    void setMode(ConflictResolutionMode mode) {
        super.set("mode", mode.name());
    }

    public String getConflictResolutionPath() {
        return super.getString("conflictResolutionPath");
    }

    void setConflictResolutionPath(String value) {
        super.set("conflictResolutionPath", value);
    }

    public String getConflictResolutionProcedure() {
        return super.getString("conflictResolutionProcedure");
    }

    void setConflictResolutionProcedure(String value) {
        super.set("conflictResolutionProcedure", value);
    }
}

