/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.shaded.org.apache.commons.cli.MissingArgumentException;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.client.util.FormattingCLIUtils;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueCLI
extends YarnCLI {
    public static final String QUEUE = "queue";
    public static final String ALLTAG = "all";

    public static void main(String[] args) throws Exception {
        QueueCLI cli = new QueueCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run(cli, args);
        cli.stop();
        System.exit(res);
    }

    @Override
    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "List queue information about given queue.");
        opts.addOption("help", false, "Displays help for all commands.");
        opts.getOption("status").setArgName("Queue Name");
        opts.addOption("list", true, "All child queues are displayed according to the parent queue. If the value is all, all queues are displayed.");
        opts.getOption("list").setArgName("Parent Queue Name");
        opts.addOption("subClusterId", true, "We support setting subClusterId in YARN Federation mode to specify specific subClusters.");
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return -1;
        }
        this.createAndStartYarnClient();
        if (cliParser.hasOption("status")) {
            if (args.length > 4) {
                this.printUsage(opts);
                return -1;
            }
            String queue = cliParser.getOptionValue("status");
            String subClusterId = cliParser.getOptionValue("subClusterId");
            if (YarnClientUtils.isYarnFederationEnabled(this.getConf()) && StringUtils.isNotBlank((CharSequence)subClusterId)) {
                return this.listQueue(queue, subClusterId);
            }
            return this.listQueue(queue);
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return 0;
        }
        if (cliParser.hasOption("list")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return -1;
            }
            return this.listChildQueues(cliParser.getOptionValue("list"));
        }
        this.syserr.println("Invalid Command Usage : ");
        this.printUsage(opts);
        return -1;
    }

    @VisibleForTesting
    void printUsage(Options opts) {
        new HelpFormatter().printHelp(QUEUE, opts);
    }

    private int listQueue(String queueName) throws YarnException, IOException {
        int rc;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, StandardCharsets.UTF_8));
        QueueInfo queueInfo = this.client.getQueueInfo(queueName);
        if (queueInfo != null) {
            if (YarnClientUtils.isYarnFederationEnabled(this.getConf())) {
                writer.println("Using YARN Federation mode.");
            }
            writer.println("Queue Information : ");
            this.printQueueInfo(writer, queueInfo);
            rc = 0;
        } else {
            writer.println("Cannot get queue from RM by queueName = " + queueName + ", please check.");
            rc = -1;
        }
        writer.flush();
        return rc;
    }

    private int listQueue(String queueName, String subClusterId) throws YarnException, IOException {
        int rc;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        QueueInfo queueInfo = this.client.getQueueInfo(queueName, subClusterId);
        if (queueInfo != null) {
            if (YarnClientUtils.isYarnFederationEnabled(this.getConf())) {
                writer.println("Using YARN Federation mode.");
            }
            if (StringUtils.isNotBlank((CharSequence)subClusterId)) {
                writer.println("SubClusterId : " + subClusterId + ", Queue Information : ");
            } else {
                writer.println("Queue Information : ");
            }
            this.printQueueInfo(writer, queueInfo);
            rc = 0;
        } else {
            writer.println("Cannot get queue from RM by queueName = " + queueName + ", subClusterId = " + subClusterId + " please check.");
            rc = -1;
        }
        writer.flush();
        return rc;
    }

    private int listChildQueues(String parentQueueName) throws IOException, YarnException {
        int exitCode;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName(StandardCharsets.UTF_8.name())));
        if (parentQueueName.equalsIgnoreCase(ALLTAG)) {
            List<QueueInfo> queueInfos = this.client.getAllQueues();
            if (queueInfos != null) {
                this.printQueueInfos(writer, queueInfos);
                exitCode = 0;
            } else {
                writer.println("Cannot get any queues from RM,please check.");
                exitCode = -1;
            }
        } else {
            List<QueueInfo> childQueueInfos = this.client.getChildQueueInfos(parentQueueName);
            if (childQueueInfos != null) {
                this.printQueueInfos(writer, childQueueInfos);
                exitCode = 0;
            } else {
                writer.println("Cannot get any queues under " + parentQueueName + " from RM,please check.");
                exitCode = -1;
            }
        }
        writer.flush();
        return exitCode;
    }

    private void printQueueInfo(PrintWriter writer, QueueInfo queueInfo) {
        String schedulerType = queueInfo.getSchedulerType();
        if (StringUtils.equals((CharSequence)"FairScheduler", (CharSequence)schedulerType)) {
            this.printFairSchedulerQueue(writer, queueInfo);
        } else {
            this.printQueue(writer, queueInfo);
        }
    }

    private void printFairSchedulerQueue(PrintWriter writer, QueueInfo queueInfo) {
        String generateQueueInfoMessage = this.generateQueueInfoMessage(queueInfo);
        writer.print(generateQueueInfoMessage);
    }

    private String generateQueueInfoMessage(QueueInfo queueInfo) {
        String queueLabel;
        StringBuilder stringBuilder = new StringBuilder();
        if (queueInfo.getSchedulerType() != null) {
            stringBuilder.append("Scheduler Name : ").append(queueInfo.getSchedulerType()).append("\n");
        }
        stringBuilder.append("Queue Name : ").append(queueInfo.getQueueName()).append("\n");
        DecimalFormat df = new DecimalFormat("0.00");
        stringBuilder.append("\tWeight : ").append(df.format(queueInfo.getWeight())).append("\n");
        stringBuilder.append("\tState : ").append((Object)queueInfo.getQueueState()).append("\n");
        stringBuilder.append("\tMinResource : ").append("<memory : ").append(queueInfo.getMinResourceMemory()).append(", vCores:").append(queueInfo.getMinResourceVCore()).append(">").append("\n");
        stringBuilder.append("\tMaxResource : ").append("<memory : ").append(queueInfo.getMaxResourceMemory()).append(", vCores:").append(queueInfo.getMaxResourceVCore()).append(">").append("\n");
        stringBuilder.append("\tReservedResource : ").append("<memory : ").append(queueInfo.getReservedResourceMemory()).append(", vCores:").append(queueInfo.getReservedResourceVCore()).append(">").append("\n");
        stringBuilder.append("\tSteadyFairShare : ").append("<memory : ").append(queueInfo.getSteadyFairShareMemory()).append(", vCores:").append(queueInfo.getSteadyFairShareVCore()).append(">").append("\n");
        Boolean queuePreemption = queueInfo.getPreemptionDisabled();
        if (queuePreemption != null) {
            stringBuilder.append("\tQueue Preemption : ").append(queuePreemption != false ? "enabled" : "disabled").append("\n");
        }
        if ((queueLabel = queueInfo.getQueueLabel()) != null && !queueLabel.trim().isEmpty()) {
            stringBuilder.append("\tLabel : ").append(queueLabel).append("\n");
        }
        return stringBuilder.toString();
    }

    private void printQueue(PrintWriter writer, QueueInfo queueInfo) {
        Boolean intraQueuePreemption;
        if (queueInfo.getSchedulerType() != null) {
            writer.print("Scheduler Name : ");
            writer.println(queueInfo.getSchedulerType());
        }
        writer.print("Queue Name : ");
        writer.println(queueInfo.getQueueName());
        writer.print("Queue Path : ");
        writer.println(queueInfo.getQueuePath());
        writer.print("\tState : ");
        writer.println((Object)queueInfo.getQueueState());
        DecimalFormat df = new DecimalFormat("#.00");
        writer.print("\tCapacity : ");
        writer.println(df.format(queueInfo.getCapacity() * 100.0f) + "%");
        writer.print("\tCurrent Capacity : ");
        writer.println(df.format(queueInfo.getCurrentCapacity() * 100.0f) + "%");
        writer.print("\tMaximum Capacity : ");
        writer.println(df.format(queueInfo.getMaximumCapacity() * 100.0f) + "%");
        writer.print("\tWeight : ");
        writer.println(df.format(queueInfo.getWeight()));
        writer.print("\tMaximum Parallel Apps : ");
        writer.println(queueInfo.getMaxParallelApps());
        writer.print("\tDefault Node Label expression : ");
        String nodeLabelExpression = queueInfo.getDefaultNodeLabelExpression();
        nodeLabelExpression = nodeLabelExpression == null || nodeLabelExpression.trim().isEmpty() ? "<DEFAULT_PARTITION>" : nodeLabelExpression;
        writer.println(nodeLabelExpression);
        Set<String> nodeLabels = queueInfo.getAccessibleNodeLabels();
        StringBuilder labelList = new StringBuilder();
        writer.print("\tAccessible Node Labels : ");
        for (String nodeLabel : nodeLabels) {
            if (labelList.length() > 0) {
                labelList.append(',');
            }
            labelList.append(nodeLabel);
        }
        writer.println(labelList);
        Boolean preemptStatus = queueInfo.getPreemptionDisabled();
        if (preemptStatus != null) {
            writer.print("\tPreemption : ");
            writer.println(preemptStatus != false ? "disabled" : "enabled");
        }
        if ((intraQueuePreemption = queueInfo.getIntraQueuePreemptionDisabled()) != null) {
            writer.print("\tIntra-queue Preemption : ");
            writer.println(intraQueuePreemption != false ? "disabled" : "enabled");
        }
    }

    private void printQueueInfos(PrintWriter writer, List<QueueInfo> queueInfos) {
        String titleString = queueInfos.size() + " queues were found";
        List<String> headerStrings = Arrays.asList("Queue Name", "Queue Path", "State", "Capacity", "Current Capacity", "Maximum Capacity", "Weight", "Maximum Parallel Apps");
        FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(titleString).addHeaders(headerStrings);
        DecimalFormat df = new DecimalFormat("#.00");
        for (QueueInfo queueInfo : queueInfos) {
            formattingCLIUtils.addLine(new Object[]{queueInfo.getQueueName(), queueInfo.getQueuePath(), queueInfo.getQueueState(), df.format(queueInfo.getCapacity() * 100.0f) + "%", df.format(queueInfo.getCurrentCapacity() * 100.0f) + "%", df.format(queueInfo.getMaximumCapacity() * 100.0f) + "%", df.format(queueInfo.getWeight()), queueInfo.getMaxParallelApps()});
        }
        writer.print(formattingCLIUtils.render());
    }
}

