/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.JWTUtils;
import org.apache.hadoop.security.authentication.util.SsoConfigurationUtil;
import org.apache.hadoop.shaded.com.auth0.jwt.JWT;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.DecodedJWT;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.apache.http.HttpEntity;
import org.apache.hadoop.shaded.org.apache.http.HttpResponse;
import org.apache.hadoop.shaded.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.hadoop.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.hadoop.shaded.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hadoop.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hadoop.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hadoop.shaded.org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTRedirectAuthenticationHandler
extends MultiMechsAuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(JWTRedirectAuthenticationHandler.class);
    public static final String AUTHENTICATION_PROVIDER_URL = "authentication.provider.url";
    public static final String JWT_CLIENT_ID = "jwt.client.id";
    public static final String JWT_CLIENT_SECRET = "jwt.client.secret";
    private static final String REDIRECT_URI_QUERY_PARAM = "redirect_uri=";
    private String authenticationProviderUrl = null;
    private String clientId = null;
    private final String delimiter = "&";
    private final String CODE = "code";

    @Override
    public void init(Properties config) throws ServletException {
        this.authenticationProviderUrl = config.getProperty(AUTHENTICATION_PROVIDER_URL, SsoConfigurationUtil.getInstance().getClientIssuer());
        if (this.authenticationProviderUrl == null) {
            throw new ServletException("Authentication provider URL must not be null - configure: authentication.provider.url");
        }
        if (this.authenticationProviderUrl.endsWith("/")) {
            this.authenticationProviderUrl = this.authenticationProviderUrl.substring(0, this.authenticationProviderUrl.length() - 1);
        }
        this.clientId = config.getProperty(JWT_CLIENT_ID, SsoConfigurationUtil.getInstance().getClientId());
    }

    @Override
    public AuthenticationToken postauthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String serializedJWT = null;
        HttpServletRequest req = request;
        serializedJWT = JWTUtils.getJWTFromCookie(req);
        if (serializedJWT == null && request.getParameter("code") == null) {
            String loginURL = this.constructLoginURL(request);
            LOG.debug("Sending redirect to: " + loginURL);
            response.sendRedirect(loginURL);
        } else if (serializedJWT == null && request.getParameter("code") != null) {
            ObjectMapper mapper = new ObjectMapper();
            String jsonJWT = this.getJWTTokenFromCode(request.getParameter("code"), request);
            JsonNode node = mapper.readTree(jsonJWT);
            String jwtStr = node.get("access_token").asText();
            DecodedJWT jwt = JWT.decode((String)jwtStr);
            if (JWTUtils.validateToken(jwt)) {
                String userName = jwt.getClaim(SsoConfigurationUtil.getInstance().getUserAttrName()).asString();
                token = new AuthenticationToken(userName, userName, this.getType());
                token.setJWTExpires(jwt.getExpiresAt().getTime());
                token.setJWTBasedToken(true);
            } else {
                String loginURL = this.constructLoginURL(request);
                LOG.info("Can't add token to cookie, because validating failed.");
                response.sendRedirect(loginURL);
            }
        } else if (serializedJWT != null) {
            String userName = null;
            DecodedJWT jwtToken = JWT.decode((String)serializedJWT);
            boolean valid = JWTUtils.validateToken(jwtToken);
            if (valid) {
                userName = jwtToken.getClaim(SsoConfigurationUtil.getInstance().getUserAttrName()).asString();
            } else {
                LOG.warn("jwtToken failed validation: " + jwtToken.getToken());
            }
            if (valid) {
                LOG.debug("Issuing AuthenticationToken for user.");
                token = new AuthenticationToken(userName, userName, this.getType());
            } else {
                String loginURL = this.constructLoginURL(request);
                LOG.info("token validation failed - sending redirect to: " + loginURL);
                response.sendRedirect(loginURL);
            }
        } else {
            LOG.info("JWT can't be found in cookies or get from the authentication server");
        }
        return token;
    }

    public String getJWTTokenFromCode(String code, HttpServletRequest request) throws IOException {
        StringBuilder content;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(this.getTokenUrl());
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        String ui2 = request.getParameter("ui2") != null ? "ui2" : "";
        urlParameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        urlParameters.add(new BasicNameValuePair("client_id", SsoConfigurationUtil.getInstance().getClientId()));
        urlParameters.add(new BasicNameValuePair("code", code));
        urlParameters.add(new BasicNameValuePair("client_secret", SsoConfigurationUtil.getInstance().getClientSecret()));
        urlParameters.add(new BasicNameValuePair("redirect_uri", request.getRequestURL().toString() + ui2 + "?" + "action" + "=processCode"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        HttpResponse response = client.execute((HttpUriRequest)post);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            String line;
            content = new StringBuilder();
            while ((line = br.readLine()) != null) {
                content.append(line);
                content.append(System.lineSeparator());
            }
        }
        return content.toString();
    }

    public String getTokenUrl() {
        return this.authenticationProviderUrl + "/protocol/openid-connect/token";
    }

    public String getAuthUrl() {
        return this.authenticationProviderUrl + "/protocol/openid-connect/auth";
    }

    @VisibleForTesting
    String constructLoginURL(HttpServletRequest request) {
        return this.getAuthUrl() + "?response_type=code" + "&" + "client_id=" + this.clientId + "&" + "scope=openid" + "&" + REDIRECT_URI_QUERY_PARAM + JWTUtils.constructURLWithHostname(request.getRequestURL().toString());
    }

    @Override
    public void addHeader(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Bearer realm=\"master\"");
    }
}

