/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.util.DataChecksum;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockNamenode {
    private static final Logger LOG = LoggerFactory.getLogger(MockNamenode.class);
    private final NamenodeProtocols mockNn;
    private String nsId;
    private HAServiceProtocol.HAServiceState haState = HAServiceProtocol.HAServiceState.STANDBY;
    private List<DatanodeInfo> dns = new ArrayList<DatanodeInfo>();
    private RPC.Server rpcServer;
    private HttpServer2 httpServer;

    public MockNamenode(String nsIdentifier) throws IOException {
        this(nsIdentifier, (Configuration)new HdfsConfiguration());
    }

    public MockNamenode(String nsIdentifier, Configuration conf) throws IOException {
        this.nsId = nsIdentifier;
        this.mockNn = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        this.setupMock();
        this.setupRPCServer(conf);
        this.setupHTTPServer(conf);
    }

    protected void setupMock() throws IOException {
        NamespaceInfo nsInfo = new NamespaceInfo(1, this.nsId, this.nsId, 1L);
        Mockito.when((Object)this.mockNn.versionRequest()).thenReturn((Object)nsInfo);
        Mockito.when((Object)this.mockNn.getServiceStatus()).thenAnswer(invocation -> {
            HAServiceStatus haStatus = new HAServiceStatus(this.getHAServiceState());
            haStatus.setNotReadyToBecomeActive("");
            return haStatus;
        });
    }

    private void setupRPCServer(Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine2.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientNNProtoXlator = new ClientNamenodeProtocolServerSideTranslatorPB((ClientProtocol)this.mockNn);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService((ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface)clientNNProtoXlator);
        int numHandlers = conf.getInt("dfs.namenode.handler.count", 10);
        this.rpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(numHandlers).build();
        NamenodeProtocolServerSideTranslatorPB nnProtoXlator = new NamenodeProtocolServerSideTranslatorPB((NamenodeProtocol)this.mockNn);
        BlockingService nnProtoPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService((NamenodeProtocolProtos.NamenodeProtocolService.BlockingInterface)nnProtoXlator);
        DFSUtil.addInternalPBProtocol((Configuration)conf, NamenodeProtocolPB.class, (BlockingService)nnProtoPbService, (RPC.Server)this.rpcServer);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbXlator = new DatanodeProtocolServerSideTranslatorPB((DatanodeProtocol)this.mockNn, 1000);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService((DatanodeProtocolProtos.DatanodeProtocolService.BlockingInterface)dnProtoPbXlator);
        DFSUtil.addInternalPBProtocol((Configuration)conf, DatanodeProtocolPB.class, (BlockingService)dnProtoPbService, (RPC.Server)this.rpcServer);
        HAServiceProtocolServerSideTranslatorPB haServiceProtoXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this.mockNn);
        BlockingService haProtoPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtoXlator);
        DFSUtil.addInternalPBProtocol((Configuration)conf, HAServiceProtocolPB.class, (BlockingService)haProtoPbService, (RPC.Server)this.rpcServer);
        this.rpcServer.addTerseExceptions(new Class[]{RemoteException.class, SafeModeException.class, FileNotFoundException.class, FileAlreadyExistsException.class, AccessControlException.class, LeaseExpiredException.class, NotReplicatedYetException.class, IOException.class, ConnectException.class, StandbyException.class});
        this.rpcServer.start();
    }

    private void setupHTTPServer(Configuration conf) throws IOException {
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("hdfs").setConf(conf).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).addEndpoint(URI.create("http://0.0.0.0:0"));
        this.httpServer = builder.build();
        this.httpServer.start();
    }

    public int getRPCPort() {
        return this.rpcServer.getListenerAddress().getPort();
    }

    public int getHTTPPort() {
        return this.httpServer.getConnectorAddress(0).getPort();
    }

    public NamenodeProtocols getMock() {
        return this.mockNn;
    }

    public String getNameserviceId() {
        return this.nsId;
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() {
        return this.haState;
    }

    public void transitionToActive() {
        this.haState = HAServiceProtocol.HAServiceState.ACTIVE;
    }

    public void transitionToStandby() {
        this.haState = HAServiceProtocol.HAServiceState.STANDBY;
    }

    public List<DatanodeInfo> getDatanodes() {
        return this.dns;
    }

    public void stop() throws Exception {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
            this.rpcServer = null;
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer = null;
        }
    }

    public void addFileSystemMock() throws IOException {
        ConcurrentSkipListMap fs = new ConcurrentSkipListMap();
        DirectoryListing l = this.mockNn.getListing(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)l).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} getListing({})", (Object)this.nsId, (Object)src);
            if (fs.get(src) == null) {
                throw new FileNotFoundException("File does not exist " + src);
            }
            if (!src.endsWith("/")) {
                src = src + "/";
            }
            SortedMap files = fs.subMap(src, src + '\uffff');
            ArrayList<HdfsFileStatus> list = new ArrayList<HdfsFileStatus>();
            for (String file : files.keySet()) {
                if (file.substring(src.length()).indexOf(47) >= 0) continue;
                HdfsFileStatus fileStatus = MockNamenode.getMockHdfsFileStatus(file, (String)fs.get(file));
                list.add(fileStatus);
            }
            HdfsFileStatus[] array = list.toArray(new HdfsFileStatus[list.size()]);
            return new DirectoryListing(array, 0);
        });
        Mockito.when((Object)this.mockNn.getFileInfo(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} getFileInfo({})", (Object)this.nsId, (Object)src);
            return MockNamenode.getMockHdfsFileStatus(src, (String)fs.get(src));
        });
        HdfsFileStatus c = this.mockNn.create(ArgumentMatchers.anyString(), (FsPermission)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (EnumSetWritable)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), (CryptoProtocolVersion[])ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Mockito.when((Object)c).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} create({})", (Object)this.nsId, (Object)src);
            boolean createParent = (Boolean)invocation.getArgument(4);
            if (createParent) {
                Path path = new Path(src).getParent();
                while (!path.isRoot()) {
                    LOG.info("{} create parent {}", (Object)this.nsId, (Object)path);
                    fs.put(path.toString(), "DIRECTORY");
                    path = path.getParent();
                }
            }
            fs.put(src, "FILE");
            return MockNamenode.getMockHdfsFileStatus(src, "FILE");
        });
        LocatedBlocks b = this.mockNn.getBlockLocations(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Mockito.when((Object)b).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} getBlockLocations({})", (Object)this.nsId, (Object)src);
            if (!fs.containsKey(src)) {
                LOG.error("{} cannot find {} for getBlockLocations", (Object)this.nsId, (Object)src);
                throw new FileNotFoundException("File does not exist " + src);
            }
            return Mockito.mock(LocatedBlocks.class);
        });
        boolean f = this.mockNn.complete(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (ExtendedBlock)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Mockito.when((Object)f).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            if (!fs.containsKey(src)) {
                LOG.error("{} cannot find {} for complete", (Object)this.nsId, (Object)src);
                throw new FileNotFoundException("File does not exist " + src);
            }
            return true;
        });
        LocatedBlock a = this.mockNn.addBlock(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (ExtendedBlock)ArgumentMatchers.any(), (DatanodeInfo[])ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (String[])ArgumentMatchers.any(), (EnumSet)ArgumentMatchers.any());
        Mockito.when((Object)a).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            if (!fs.containsKey(src)) {
                LOG.error("{} cannot find {} for addBlock", (Object)this.nsId, (Object)src);
                throw new FileNotFoundException("File does not exist " + src);
            }
            return MockNamenode.getMockLocatedBlock(this.nsId);
        });
        boolean m = this.mockNn.mkdirs(ArgumentMatchers.anyString(), (FsPermission)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)m).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} mkdirs({})", (Object)this.nsId, (Object)src);
            boolean createParent = (Boolean)invocation.getArgument(2);
            if (createParent) {
                Path path = new Path(src).getParent();
                while (!path.isRoot()) {
                    LOG.info("{} mkdir parent {}", (Object)this.nsId, (Object)path);
                    fs.put(path.toString(), "DIRECTORY");
                    path = path.getParent();
                }
            }
            fs.put(src, "DIRECTORY");
            return true;
        });
        Mockito.when((Object)this.mockNn.getServerDefaults()).thenAnswer(invocation -> {
            LOG.info("{} getServerDefaults", (Object)this.nsId);
            FsServerDefaults defaults = (FsServerDefaults)Mockito.mock(FsServerDefaults.class);
            Mockito.when((Object)defaults.getChecksumType()).thenReturn((Object)DataChecksum.Type.valueOf((int)1));
            Mockito.when((Object)defaults.getKeyProviderUri()).thenReturn((Object)this.nsId);
            return defaults;
        });
        Mockito.when((Object)this.mockNn.getContentSummary(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String src = MockNamenode.getSrc(invocation);
            LOG.info("{} getContentSummary({})", (Object)this.nsId, (Object)src);
            if (fs.get(src) == null) {
                throw new FileNotFoundException("File does not exist " + src);
            }
            if (!src.endsWith("/")) {
                src = src + "/";
            }
            SortedMap files = fs.subMap(src, src + '\uffff');
            int numFiles = 0;
            int numDirs = 0;
            int length = 0;
            for (Map.Entry entry : files.entrySet()) {
                String file = (String)entry.getKey();
                if (file.substring(src.length()).indexOf(47) >= 0) continue;
                String type = (String)entry.getValue();
                if ("DIRECTORY".equals(type)) {
                    ++numDirs;
                    continue;
                }
                if (!"FILE".equals(type)) continue;
                ++numFiles;
                length += 100;
            }
            return new ContentSummary.Builder().fileCount((long)numFiles).directoryCount((long)numDirs).length((long)length).erasureCodingPolicy("").build();
        });
    }

    public void addDatanodeMock() throws IOException {
        Mockito.when((Object)this.mockNn.getDatanodeReport((HdfsConstants.DatanodeReportType)ArgumentMatchers.any(HdfsConstants.DatanodeReportType.class))).thenAnswer(invocation -> {
            LOG.info("{} getDatanodeReport()", (Object)this.nsId, invocation.getArgument(0));
            return this.dns.toArray();
        });
        Mockito.when((Object)this.mockNn.getDatanodeStorageReport((HdfsConstants.DatanodeReportType)ArgumentMatchers.any(HdfsConstants.DatanodeReportType.class))).thenAnswer(invocation -> {
            LOG.info("{} getDatanodeStorageReport()", (Object)this.nsId, invocation.getArgument(0));
            DatanodeStorageReport[] ret = new DatanodeStorageReport[this.dns.size()];
            for (int i = 0; i < this.dns.size(); ++i) {
                DatanodeInfo dn = this.dns.get(i);
                DatanodeStorage storage = new DatanodeStorage(dn.getName());
                StorageReport[] storageReports = new StorageReport[]{new StorageReport(storage, false, 0L, 0L, 0L, 0L, 0L)};
                ret[i] = new DatanodeStorageReport(dn, storageReports);
            }
            return ret;
        });
    }

    private static String getSrc(InvocationOnMock invocation) {
        return (String)invocation.getArguments()[0];
    }

    private static HdfsFileStatus getMockHdfsFileStatus(String filename, String type) {
        if (type == null) {
            return null;
        }
        HdfsFileStatus fileStatus = (HdfsFileStatus)Mockito.mock(HdfsFileStatus.class);
        Mockito.when((Object)fileStatus.getLocalNameInBytes()).thenReturn((Object)filename.getBytes());
        Mockito.when((Object)fileStatus.getPermission()).thenReturn((Object)((FsPermission)Mockito.mock(FsPermission.class)));
        Mockito.when((Object)fileStatus.getOwner()).thenReturn((Object)"owner");
        Mockito.when((Object)fileStatus.getGroup()).thenReturn((Object)"group");
        if (type.equals("FILE")) {
            Mockito.when((Object)fileStatus.getLen()).thenReturn((Object)100L);
            Mockito.when((Object)fileStatus.getReplication()).thenReturn((Object)1);
            Mockito.when((Object)fileStatus.getBlockSize()).thenReturn((Object)0x8000000L);
        } else if (type.equals("DIRECTORY")) {
            Mockito.when((Object)fileStatus.isDir()).thenReturn((Object)true);
            Mockito.when((Object)fileStatus.isDirectory()).thenReturn((Object)true);
        }
        return fileStatus;
    }

    private static LocatedBlock getMockLocatedBlock(String nsId) {
        LocatedBlock lb = (LocatedBlock)Mockito.mock(LocatedBlock.class);
        Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)DatanodeInfo.EMPTY_ARRAY);
        DatanodeID nodeId = new DatanodeID("localhost", "localhost", "dn0", 1111, 1112, 1113, 1114);
        DatanodeDescriptor dnInfo = new DatanodeDescriptor(nodeId);
        DatanodeInfoWithStorage datanodeInfoWithStorage = new DatanodeInfoWithStorage((DatanodeInfo)dnInfo, "storageID", StorageType.DEFAULT);
        Mockito.when((Object)lb.getLocations()).thenReturn((Object)new DatanodeInfoWithStorage[]{datanodeInfoWithStorage});
        ExtendedBlock eb = (ExtendedBlock)Mockito.mock(ExtendedBlock.class);
        Mockito.when((Object)eb.getBlockPoolId()).thenReturn((Object)nsId);
        Mockito.when((Object)lb.getBlock()).thenReturn((Object)eb);
        Token tok = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)tok.getIdentifier()).thenReturn((Object)nsId.getBytes());
        Mockito.when((Object)tok.getPassword()).thenReturn((Object)nsId.getBytes());
        Mockito.when((Object)tok.getKind()).thenReturn((Object)new Text(nsId));
        Mockito.when((Object)tok.getService()).thenReturn((Object)new Text(nsId));
        Mockito.when((Object)lb.getBlockToken()).thenReturn((Object)tok);
        return lb;
    }

    public static void registerSubclusters(Router router, Collection<MockNamenode> namenodes) throws IOException {
        MockNamenode.registerSubclusters(Collections.singletonList(router), namenodes, Collections.emptySet());
    }

    public static void registerSubclusters(List<Router> routers, Collection<MockNamenode> namenodes, Set<String> unavailableSubclusters) throws IOException {
        for (Router router : routers) {
            MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)router.getNamenodeResolver();
            for (MockNamenode nn : namenodes) {
                String nsId = nn.getNameserviceId();
                String rpcAddress = "localhost:" + nn.getRPCPort();
                String httpAddress = "localhost:" + nn.getHTTPPort();
                String scheme = "http";
                NamenodeStatusReport report = new NamenodeStatusReport(nsId, null, rpcAddress, rpcAddress, rpcAddress, scheme, httpAddress);
                if (unavailableSubclusters.contains(nsId)) {
                    LOG.info("Register {} as UNAVAILABLE", (Object)nsId);
                    report.setRegistrationValid(false);
                } else {
                    LOG.info("Register {} as ACTIVE", (Object)nsId);
                    report.setRegistrationValid(true);
                }
                report.setNamespaceInfo(new NamespaceInfo(0, nsId, nsId, 0L));
                resolver.registerNamenode(report);
            }
            resolver.loadCache(true);
        }
    }
}

