/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event.multidispatcher;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;

class MultiDispatcherLibrary {
    private final Map<String, EventHandler> lib = new HashMap<String, EventHandler>();

    MultiDispatcherLibrary() {
    }

    public EventHandler getEventHandler(Event e) {
        EventHandler handler = this.lib.get(e.getType().getClass().getCanonicalName());
        if (handler == null) {
            throw new Error("EventHandler for " + e.getType() + ", was not found in " + this.lib.keySet());
        }
        return handler;
    }

    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        this.lib.put(eventType.getCanonicalName(), handler);
    }
}

