/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.ha.MiniZKFCCluster;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.ZKFCRpcServer;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.event.Level;

@Ignore
public class TestZKFailoverController
extends ClientBaseWithFixes {
    private Configuration conf;
    private MiniZKFCCluster cluster;
    @Rule
    public Timeout testTimeout = new Timeout(3L, TimeUnit.MINUTES);
    private static final String DIGEST_USER_PASS = "test-user:test-password";
    private static final String TEST_AUTH_GOOD = "digest:test-user:test-password";
    private static final String DIGEST_USER_HASH;
    private static final String TEST_ACL;

    @Before
    public void setupConfAndServices() {
        this.conf = new Configuration();
        this.conf.set("ha.zookeeper.acl", TEST_ACL);
        this.conf.set("ha.zookeeper.auth", TEST_AUTH_GOOD);
        this.conf.set("ha.zookeeper.quorum", this.hostPort);
        this.cluster = new MiniZKFCCluster(this.conf, TestZKFailoverController.getServer(this.serverFactory));
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            try {
                this.cluster.stop();
            }
            catch (Exception e) {
                LOG.warn("When stopping the cluster", (Throwable)e);
            }
        }
    }

    @Test
    public void testFormatZK() throws Exception {
        DummyHAService svc = this.cluster.getService(1);
        Assert.assertEquals((long)3L, (long)this.runFC(svc, new String[0]));
        Assert.assertEquals((long)0L, (long)this.runFC(svc, "-formatZK"));
        Assert.assertEquals((long)2L, (long)this.runFC(svc, "-formatZK", "-nonInteractive"));
        Assert.assertEquals((long)0L, (long)this.runFC(svc, "-formatZK", "-force"));
    }

    @Test
    public void testNoZK() throws Exception {
        this.stopServer();
        DummyHAService svc = this.cluster.getService(1);
        Assert.assertEquals((long)6L, (long)this.runFC(svc, new String[0]));
    }

    @Test
    public void testPolicyProviderForZKFCRpcServer() throws Exception {
        Configuration myconf = new Configuration();
        myconf.setBoolean("hadoop.security.authorization", true);
        DummyHAService dummyHAService = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress(0), false);
        MiniZKFCCluster.DummyZKFC dummyZKFC = new MiniZKFCCluster.DummyZKFC(myconf, dummyHAService);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, "hadoop.security.authorizationis configured to true but service-levelauthorization security policy is null.", () -> new ZKFCRpcServer(myconf, new InetSocketAddress(0), (ZKFailoverController)dummyZKFC, null));
        PolicyProvider dummyPolicy = new PolicyProvider(){
            private final Service[] services = new Service[]{new Service("security.zkfc.protocol.acl", ZKFCProtocol.class), new Service("security.refresh.policy.protocol.acl", RefreshAuthorizationPolicyProtocol.class)};

            public Service[] getServices() {
                return this.services;
            }
        };
        ZKFCRpcServer server = new ZKFCRpcServer(myconf, new InetSocketAddress(0), (ZKFailoverController)dummyZKFC, dummyPolicy);
        server.start();
        server.stopAndJoin();
    }

    @Test
    public void testFormatOneClusterLeavesOtherClustersAlone() throws Exception {
        DummyHAService svc = this.cluster.getService(1);
        MiniZKFCCluster.DummyZKFC zkfcInOtherCluster = new MiniZKFCCluster.DummyZKFC(this.conf, this.cluster.getService(1)){

            @Override
            protected String getScopeInsideParentNode() {
                return "other-scope";
            }
        };
        Assert.assertEquals((long)3L, (long)this.runFC(svc, new String[0]));
        Assert.assertEquals((long)0L, (long)this.runFC(svc, "-formatZK"));
        Assert.assertEquals((long)3L, (long)zkfcInOtherCluster.run(new String[0]));
        Assert.assertEquals((long)0L, (long)zkfcInOtherCluster.run(new String[]{"-formatZK"}));
        Assert.assertEquals((long)2L, (long)this.runFC(svc, "-formatZK", "-nonInteractive"));
    }

    @Test
    public void testWontRunWhenAutoFailoverDisabled() throws Exception {
        DummyHAService svc = this.cluster.getService(1);
        svc = (DummyHAService)((Object)Mockito.spy((Object)((Object)svc)));
        ((DummyHAService)((Object)Mockito.doReturn((Object)false).when((Object)svc))).isAutoFailoverEnabled();
        Assert.assertEquals((long)5L, (long)this.runFC(svc, "-formatZK"));
        Assert.assertEquals((long)5L, (long)this.runFC(svc, new String[0]));
    }

    @Test
    public void testFormatSetsAcls() throws Exception {
        DummyHAService svc = this.cluster.getService(1);
        Assert.assertEquals((long)0L, (long)this.runFC(svc, "-formatZK"));
        TestableZooKeeper otherClient = this.createClient();
        try {
            Stat stat = new Stat();
            otherClient.getData("/hadoop-ha", false, stat);
            Assert.fail((String)"Was able to read data without authenticating!");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
    }

    @Test
    public void testFencingMustBeConfigured() throws Exception {
        DummyHAService svc = (DummyHAService)((Object)Mockito.spy((Object)((Object)this.cluster.getService(0))));
        ((DummyHAService)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new BadFencingConfigurationException("no fencing")}).when((Object)svc))).checkFencingConfigured();
        Assert.assertEquals((long)0L, (long)this.runFC(svc, "-formatZK"));
        Assert.assertEquals((long)4L, (long)this.runFC(svc, new String[0]));
    }

    @Test
    public void testAutoFailoverOnBadHealth() throws Exception {
        this.cluster.start();
        DummyHAService svc1 = this.cluster.getService(1);
        LOG.info("Faking svc0 unhealthy, should failover to svc1");
        this.cluster.setHealthy(0, false);
        LOG.info("Waiting for svc0 to enter initializing state");
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.INITIALIZING);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
        LOG.info("Allowing svc0 to be healthy again, making svc1 unreachable and fail to gracefully go to standby");
        this.cluster.setUnreachable(1, true);
        this.cluster.setHealthy(0, true);
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        ((NodeFencer)Mockito.verify((Object)svc1.fencer)).fence((HAServiceTarget)Mockito.same((Object)((Object)svc1)));
    }

    @Test
    public void testAutoFailoverOnBadState() throws Exception {
        this.cluster.start();
        DummyHAService svc0 = this.cluster.getService(0);
        LOG.info("Faking svc0 to change the state, should failover to svc1");
        svc0.state = HAServiceProtocol.HAServiceState.STANDBY;
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
    }

    @Test
    public void testAutoFailoverOnLostZKSession() throws Exception {
        this.cluster.start();
        this.cluster.expireAndVerifyFailover(0, 1);
        this.cluster.expireAndVerifyFailover(1, 0);
        LOG.info("======= Running test cases second time to test re-establishment =========");
        this.cluster.expireAndVerifyFailover(0, 1);
        this.cluster.expireAndVerifyFailover(1, 0);
    }

    @Test
    public void testVerifyObserverState() throws Exception {
        this.cluster.start(3);
        DummyHAService svc2 = this.cluster.getService(2);
        svc2.state = HAServiceProtocol.HAServiceState.OBSERVER;
        LOG.info("Waiting for svc2 to enter observer state");
        this.cluster.waitForHAState(2, HAServiceProtocol.HAServiceState.OBSERVER);
    }

    @Test
    public void testDontFailoverToUnhealthyNode() throws Exception {
        this.cluster.start();
        this.cluster.setHealthy(1, false);
        this.cluster.waitForHealthState(1, HealthMonitor.State.SERVICE_UNHEALTHY);
        this.cluster.getElector(0).preventSessionReestablishmentForTests();
        try {
            this.cluster.expireActiveLockHolder(0);
            LOG.info("Expired svc0's ZK session. Waiting a second to give svc1 a chance to take the lock, if it is ever going to.");
            Thread.sleep(1000L);
            this.cluster.waitForActiveLockHolder(null);
        }
        finally {
            LOG.info("Allowing svc0's elector to re-establish its connection");
            this.cluster.getElector(0).allowSessionReestablishmentForTests();
        }
        this.cluster.waitForActiveLockHolder(0);
    }

    @Test
    public void testBecomingActiveFails() throws Exception {
        this.cluster.start();
        DummyHAService svc1 = this.cluster.getService(1);
        LOG.info("Making svc1 fail to become active");
        this.cluster.setFailToBecomeActive(1, true);
        LOG.info("Faking svc0 unhealthy, should NOT successfully failover to svc1");
        this.cluster.setHealthy(0, false);
        this.cluster.waitForHealthState(0, HealthMonitor.State.SERVICE_UNHEALTHY);
        this.cluster.waitForActiveLockHolder(null);
        ((HAServiceProtocol)Mockito.verify((Object)svc1.proxy, (VerificationMode)Mockito.timeout((long)2000L).atLeastOnce())).transitionToActive((HAServiceProtocol.StateChangeRequestInfo)Mockito.any());
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.INITIALIZING);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
        LOG.info("Faking svc0 healthy again, should go back to svc0");
        this.cluster.setHealthy(0, true);
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
        this.cluster.waitForActiveLockHolder(0);
        LOG.info("Allowing svc1 to become active, expiring svc0");
        svc1.failToBecomeActive = false;
        this.cluster.expireAndVerifyFailover(0, 1);
    }

    @Test
    public void testZooKeeperFailure() throws Exception {
        this.cluster.start();
        long session0 = this.cluster.getElector(0).getZKSessionIdForTests();
        long session1 = this.cluster.getElector(1).getZKSessionIdForTests();
        LOG.info("====== Stopping ZK server");
        this.stopServer();
        TestZKFailoverController.waitForServerDown(this.hostPort, CONNECTION_TIMEOUT);
        LOG.info("====== Waiting for services to enter NEUTRAL mode");
        this.cluster.waitForElectorState(0, ActiveStandbyElector.State.NEUTRAL);
        this.cluster.waitForElectorState(1, ActiveStandbyElector.State.NEUTRAL);
        LOG.info("====== Checking that the services didn't change HA state");
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.cluster.getService((int)0).state);
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)this.cluster.getService((int)1).state);
        LOG.info("====== Restarting server");
        this.startServer();
        TestZKFailoverController.waitForServerUp(this.hostPort, CONNECTION_TIMEOUT);
        this.cluster.waitForElectorState(0, ActiveStandbyElector.State.ACTIVE);
        this.cluster.waitForElectorState(1, ActiveStandbyElector.State.STANDBY);
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
        Assert.assertEquals((long)session0, (long)this.cluster.getElector(0).getZKSessionIdForTests());
        Assert.assertEquals((long)session1, (long)this.cluster.getElector(1).getZKSessionIdForTests());
    }

    @Test
    public void testCedeActive() throws Exception {
        this.cluster.start();
        MiniZKFCCluster.DummyZKFC zkfc = this.cluster.getZkfc(0);
        Assert.assertEquals((Object)ActiveStandbyElector.State.ACTIVE, (Object)zkfc.getElectorForTests().getStateForTests());
        ZKFCProtocol proxy = zkfc.getLocalTarget().getZKFCProxy(this.conf, 5000);
        long st = Time.now();
        proxy.cedeActive(3000);
        long et = Time.now();
        Assert.assertTrue((String)("RPC to cedeActive took " + (et - st) + " ms"), (et - st < 1000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)ActiveStandbyElector.State.INIT, (Object)zkfc.getElectorForTests().getStateForTests());
        this.cluster.waitForElectorState(0, ActiveStandbyElector.State.STANDBY);
        long et2 = Time.now();
        Assert.assertTrue((String)("Should take ~3 seconds to rejoin. Only took " + (et2 - et) + "ms before rejoining."), (et2 - et > 2800L ? 1 : 0) != 0);
    }

    @Test
    public void testGracefulFailover() throws Exception {
        this.cluster.start();
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
        this.cluster.waitForActiveLockHolder(1);
        this.cluster.getService(0).getZKFCProxy(this.conf, 5000).gracefulFailover();
        this.cluster.waitForActiveLockHolder(0);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)0).fenceCount == 0 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)1).fenceCount == 0 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)0).activeTransitionCount == 2 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)1).activeTransitionCount == 1;
            }
        }, 100L, 60000L);
    }

    @Test
    public void testGracefulFailoverToUnhealthy() throws Exception {
        this.cluster.start();
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.setHealthy(1, false);
        this.cluster.waitForElectorState(1, ActiveStandbyElector.State.INIT);
        try {
            this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
            Assert.fail((String)"Did not fail to graceful failover to unhealthy service!");
        }
        catch (ServiceFailedException sfe) {
            GenericTestUtils.assertExceptionContains(this.cluster.getService(1).toString() + " is not currently healthy.", sfe);
        }
    }

    @Test
    public void testObserverExitGracefulFailover() throws Exception {
        this.cluster.start(3);
        this.cluster.waitForActiveLockHolder(0);
        DummyHAService svc2 = this.cluster.getService(2);
        svc2.state = HAServiceProtocol.HAServiceState.OBSERVER;
        this.cluster.waitForHAState(2, HAServiceProtocol.HAServiceState.OBSERVER);
        this.cluster.setFailToBecomeActive(2, true);
        this.cluster.setFailToBecomeStandby(2, true);
        this.cluster.setFailToBecomeObserver(2, true);
        this.cluster.waitForElectorState(2, ActiveStandbyElector.State.INIT);
        try {
            this.cluster.getService(2).getZKFCProxy(this.conf, 5000).gracefulFailover();
            Assert.fail((String)"Did not fail to graceful failover to observer!");
        }
        catch (ServiceFailedException sfe) {
            GenericTestUtils.assertExceptionContains(this.cluster.getService(2).toString() + " is in observer state.", sfe);
        }
    }

    @Test
    public void testGracefulFailoverFailBecomingActive() throws Exception {
        this.cluster.start();
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.setFailToBecomeActive(1, true);
        try {
            this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
            Assert.fail((String)"Did not fail to graceful failover when target failed to become active!");
        }
        catch (ServiceFailedException sfe) {
            GenericTestUtils.assertExceptionContains("Couldn't make " + (Object)((Object)this.cluster.getService(1)) + " active", sfe);
            GenericTestUtils.assertExceptionContains("injected failure", sfe);
        }
        Assert.assertEquals((long)0L, (long)this.cluster.getService((int)0).fenceCount);
        Assert.assertEquals((long)0L, (long)this.cluster.getService((int)1).fenceCount);
        this.cluster.waitForActiveLockHolder(0);
    }

    @Test
    public void testGracefulFailoverFailBecomingStandby() throws Exception {
        this.cluster.start();
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.setFailToBecomeStandby(0, true);
        this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
        Assert.assertEquals((long)1L, (long)this.cluster.getService((int)0).fenceCount);
    }

    @Test
    public void testGracefulFailoverFailBecomingStandbyAndFailFence() throws Exception {
        this.cluster.start();
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.setFailToBecomeStandby(0, true);
        this.cluster.setFailToFence(0, true);
        try {
            this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
            Assert.fail((String)"Failover should have failed when old node wont fence");
        }
        catch (ServiceFailedException sfe) {
            GenericTestUtils.assertExceptionContains("Unable to fence " + (Object)((Object)this.cluster.getService(0)), sfe);
        }
    }

    @Test
    public void testOneOfEverything() throws Exception {
        this.cluster.start();
        LOG.info("====== Failing over by session expiration");
        this.cluster.expireAndVerifyFailover(0, 1);
        this.cluster.expireAndVerifyFailover(1, 0);
        LOG.info("====== Restarting server");
        this.stopServer();
        TestZKFailoverController.waitForServerDown(this.hostPort, CONNECTION_TIMEOUT);
        this.startServer();
        TestZKFailoverController.waitForServerUp(this.hostPort, CONNECTION_TIMEOUT);
        this.cluster.setHealthy(0, false);
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.INITIALIZING);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
        this.cluster.setHealthy(1, true);
        this.cluster.setHealthy(0, false);
        this.cluster.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
        this.cluster.waitForHAState(0, HAServiceProtocol.HAServiceState.INITIALIZING);
        this.cluster.setHealthy(0, true);
        this.cluster.waitForHealthState(0, HealthMonitor.State.SERVICE_HEALTHY);
        this.cluster.getZkfc(1).gracefulFailoverToYou();
        this.cluster.getZkfc(0).gracefulFailoverToYou();
    }

    @Test
    public void testGracefulFailoverMultipleZKfcs() throws Exception {
        this.cluster.start(3);
        this.cluster.waitForActiveLockHolder(0);
        this.cluster.getService(1).getZKFCProxy(this.conf, 5000).gracefulFailover();
        this.cluster.waitForActiveLockHolder(1);
        this.cluster.getService(2).getZKFCProxy(this.conf, 5000).gracefulFailover();
        this.cluster.waitForActiveLockHolder(2);
        this.cluster.getService(0).getZKFCProxy(this.conf, 5000).gracefulFailover();
        this.cluster.waitForActiveLockHolder(0);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)0).fenceCount == 0 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)1).fenceCount == 0 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)2).fenceCount == 0 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)0).activeTransitionCount == 2 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)1).activeTransitionCount == 1 && ((TestZKFailoverController)TestZKFailoverController.this).cluster.getService((int)2).activeTransitionCount == 1;
            }
        }, 100L, 60000L);
    }

    private int runFC(DummyHAService target, String ... args) throws Exception {
        MiniZKFCCluster.DummyZKFC zkfc = new MiniZKFCCluster.DummyZKFC(this.conf, target);
        return zkfc.run(args);
    }

    static {
        try {
            DIGEST_USER_HASH = DigestAuthenticationProvider.generateDigest((String)DIGEST_USER_PASS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        TEST_ACL = "digest:" + DIGEST_USER_HASH + ":rwcda";
        GenericTestUtils.setLogLevel(ActiveStandbyElector.LOG, Level.TRACE);
    }
}

