/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;

@InterfaceStability.Evolving
@InterfaceAudience.LimitedPrivate(value={"yarn"})
public interface Queue {
    public String getQueueName();

    public QueueMetrics getMetrics();

    public QueueInfo getQueueInfo(boolean var1, boolean var2);

    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation var1);

    public boolean hasAccess(QueueACL var1, UserGroupInformation var2);

    public AbstractUsersManager getAbstractUsersManager();

    public void recoverContainer(Resource var1, SchedulerApplicationAttempt var2, RMContainer var3);

    public Set<String> getAccessibleNodeLabels();

    public String getDefaultNodeLabelExpression();

    public void incPendingResource(String var1, Resource var2);

    public void decPendingResource(String var1, Resource var2);

    public Priority getDefaultApplicationPriority();

    public void incReservedResource(String var1, Resource var2);

    public void decReservedResource(String var1, Resource var2);

    public String getLabel();
}

