/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.UserGroupInformation;

public class AuthFilterInitializer
extends FilterInitializer {
    private String configPrefix = "hadoop.http.authentication.";

    protected Map<String, String> createFilterConfig(Configuration conf) {
        Map filterConfig = AuthenticationFilterInitializer.getFilterConfigMap((Configuration)conf, (String)this.configPrefix);
        for (Map.Entry entry : conf.getPropsWithPrefix("hadoop.proxyuser").entrySet()) {
            filterConfig.put("proxyuser" + (String)entry.getKey(), (String)entry.getValue());
        }
        if (filterConfig.get("type") == null) {
            filterConfig.put("type", UserGroupInformation.isSecurityEnabled() ? "kerberos" : "simple");
        }
        filterConfig.put("cookie.path", "/");
        return filterConfig;
    }

    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        container.addFilter("AuthFilter", AuthFilter.class.getName(), filterConfig);
    }
}

