/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TransportData {
    private final BCSSLParameters parameters;
    private final BCExtendedSSLSession handshakeSession;

    static TransportData from(Socket socket) {
        if (!(socket instanceof SSLSocket) || !socket.isConnected()) {
            return null;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        BCSSLParameters parameters = SSLSocketUtil.importSSLParameters(sslSocket);
        if (null == parameters) {
            return null;
        }
        BCExtendedSSLSession handshakeSession = SSLSocketUtil.importHandshakeSession(sslSocket);
        return new TransportData(parameters, handshakeSession);
    }

    static TransportData from(SSLEngine engine) {
        if (null == engine) {
            return null;
        }
        BCSSLParameters parameters = SSLEngineUtil.importSSLParameters(engine);
        if (null == parameters) {
            return null;
        }
        BCExtendedSSLSession handshakeSession = SSLEngineUtil.importHandshakeSession(engine);
        return new TransportData(parameters, handshakeSession);
    }

    static BCAlgorithmConstraints getAlgorithmConstraints(TransportData transportData, boolean peerSigAlgs) {
        return null == transportData ? ProvAlgorithmConstraints.DEFAULT : transportData.getAlgorithmConstraints(peerSigAlgs);
    }

    static List<byte[]> getStatusResponses(TransportData transportData) {
        return null == transportData ? Collections.emptyList() : transportData.getStatusResponses();
    }

    private TransportData(BCSSLParameters parameters, BCExtendedSSLSession handshakeSession) {
        this.parameters = parameters;
        this.handshakeSession = handshakeSession;
    }

    BCSSLParameters getParameters() {
        return this.parameters;
    }

    BCExtendedSSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    BCAlgorithmConstraints getAlgorithmConstraints(boolean peerSigAlgs) {
        BCAlgorithmConstraints configAlgorithmConstraints = this.parameters.getAlgorithmConstraints();
        if (ProvAlgorithmConstraints.DEFAULT == configAlgorithmConstraints) {
            configAlgorithmConstraints = null;
        }
        if (null != this.handshakeSession && JsseUtils.isTLSv12(this.handshakeSession.getProtocol())) {
            String[] sigAlgsCert;
            String[] stringArray = sigAlgsCert = peerSigAlgs ? this.handshakeSession.getPeerSupportedSignatureAlgorithmsBC() : this.handshakeSession.getLocalSupportedSignatureAlgorithmsBC();
            if (null != sigAlgsCert) {
                return new ProvAlgorithmConstraints(configAlgorithmConstraints, sigAlgsCert, true);
            }
        }
        return null == configAlgorithmConstraints ? ProvAlgorithmConstraints.DEFAULT : new ProvAlgorithmConstraints(configAlgorithmConstraints, true);
    }

    List<byte[]> getStatusResponses() {
        return null == this.handshakeSession ? Collections.emptyList() : this.handshakeSession.getStatusResponses();
    }
}

