/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Context;
import org.apache.hadoop.shaded.org.glassfish.grizzly.EmptyCompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.FileTransfer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEventProcessingHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.PortRange;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Processor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorExecutor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Reader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.SocketBinder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.SocketConnectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.StandaloneProcessor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.StandaloneProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Transport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.WriteResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Writer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.Filter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.ByteBufferArray;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.RegisterChannelResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.SelectorRunner;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOBindingHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOConnectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOTransportFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.apache.hadoop.shaded.org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.Futures;

public final class UDPNIOTransport
extends NIOTransport
implements SocketBinder<UDPNIOServerConnection>,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    static final Logger LOGGER = Grizzly.logger(UDPNIOTransport.class);
    private static final String DEFAULT_TRANSPORT_NAME = "UDPNIOTransport";
    protected final int serverSocketSoTimeout = 0;
    protected boolean reuseAddress = true;
    protected int connectionTimeout = 30000;
    protected final Collection<UDPNIOServerConnection> serverConnections;
    protected final AsyncQueueIO<SocketAddress> asyncQueueIO;
    protected final TemporarySelectorIO temporarySelectorIO;
    private final Filter transportFilter;
    protected final RegisterChannelCompletionHandler registerChannelCompletionHandler;
    private final UDPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private final UDPNIOBindingHandler bindingHandler = new TransportBindingHandler();

    public UDPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    public UDPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.registerChannelCompletionHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = AsyncQueueIO.Factory.createImmutable(new UDPNIOAsyncQueueReader(this), new UDPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new UDPNIOTemporarySelectorReader(this), new UDPNIOTemporarySelectorWriter(this));
        this.transportFilter = new UDPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<UDPNIOServerConnection>();
    }

    @Override
    public UDPNIOServerConnection bind(int port) throws IOException {
        return (UDPNIOServerConnection)this.bindingHandler.bind(port);
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port) throws IOException {
        return (UDPNIOServerConnection)this.bindingHandler.bind(host, port);
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return (UDPNIOServerConnection)this.bindingHandler.bind(host, port, backlog);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bindingHandler.bind(socketAddress);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindingHandler.bind(socketAddress, backlog);
    }

    @Override
    public UDPNIOServerConnection bindToInherited() throws IOException {
        return this.bindingHandler.bindToInherited();
    }

    @Override
    public UDPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        int offset;
        int lower = portRange.getLower();
        int range = portRange.getUpper() - lower + 1;
        int start = offset = RANDOM.nextInt(range);
        while (true) {
            int port = lower + offset;
            try {
                return this.bind(host, port, backlog);
            }
            catch (IOException e) {
                IOException ioException = e;
                if ((offset = (offset + 1) % range) != start) continue;
                throw ioException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UDPNIOServerConnection connection) throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (connection != null && this.serverConnections.remove(connection)) {
                FutureImpl future = Futures.createSafeFuture();
                connection.unbind(Futures.toCompletionHandler(future));
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                    future.recycle(false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_UNBINDING_CONNECTION_EXCEPTION(connection), e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (UDPNIOServerConnection serverConnection : this.serverConnections) {
                try {
                    this.unbind(serverConnection);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public GrizzlyFuture<Connection> connect() throws IOException {
        return this.connectorHandler.connect();
    }

    public GrizzlyFuture<Connection> connect(String host, int port) throws IOException {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connectorHandler.connect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "UDPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState());
            if (currentState != Transport.State.STOP) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_NOT_STOP_OR_BOUND_STATE_EXCEPTION());
            }
            this.state.setState(Transport.State.STARTING);
            super.start();
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = new StandaloneProcessor();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = Runtime.getRuntime().availableProcessors();
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.kernelPool == null) {
                this.kernelPoolConfig.setMemoryManager(this.memoryManager);
                this.setKernelPool0(GrizzlyExecutorService.createInstance(this.kernelPoolConfig));
            }
            if (this.workerThreadPool == null && this.workerPoolConfig != null) {
                this.workerPoolConfig.getInitialMonitoringConfig().addProbes((ThreadPoolProbe[])this.getThreadPoolMonitoringConfig().getProbes());
                this.workerPoolConfig.setMemoryManager(this.memoryManager);
                this.setWorkerThreadPool0(GrizzlyExecutorService.createInstance(this.workerPoolConfig));
            }
            int selectorPoolSize = 32;
            if (this.workerThreadPool instanceof AbstractThreadPool) {
                selectorPoolSize = this.strategy instanceof SameThreadIOStrategy ? this.selectorRunnersCount : Math.min(((AbstractThreadPool)this.workerThreadPool).getConfig().getMaxPoolSize(), selectorPoolSize);
            }
            if (this.strategy == null) {
                this.strategy = WorkerThreadIOStrategy.getInstance();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(this.selectorProvider, selectorPoolSize));
            this.startSelectorRunners();
            this.registerServerConnections();
            this.state.setState(Transport.State.START);
            UDPNIOTransport.notifyProbesStart(this);
        }
        finally {
            lock.unlock();
        }
    }

    private void registerServerConnections() {
        for (UDPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.register();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_START_SERVER_CONNECTION_EXCEPTION(serverConnection), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() == Transport.State.PAUSE) {
                this.resume();
            }
            this.unbindAll();
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.workerThreadPool != null && this.managedWorkerPool) {
                this.workerThreadPool.shutdown();
                this.workerThreadPool = null;
            }
            if (this.kernelPool != null) {
                this.kernelPool.shutdownNow();
                this.kernelPool = null;
            }
            UDPNIOTransport.notifyProbesStop(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.START) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_NOT_START_STATE_EXCEPTION());
            }
            this.state.setState(Transport.State.PAUSE);
            UDPNIOTransport.notifyProbesPause(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.PAUSE) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_NOT_PAUSE_STATE_EXCEPTION());
            }
            this.state.setState(Transport.State.START);
            UDPNIOTransport.notifyProbesResume(this);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    @Override
    public Filter getTransportFilter() {
        return this.transportFilter;
    }

    @Override
    public AsyncQueueIO getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        UDPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        UDPNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler) {
        Processor conProcessor = connection.obtainProcessor(ioEvent);
        ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, processingHandler));
    }

    @Override
    public Reader getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    private int readConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int read;
        SocketAddress peerAddress = connection.getPeerAddress();
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            ByteBufferArray array = buffer.toByteBufferArray();
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size = array.size();
            read = (int)((DatagramChannel)connection.getChannel()).read(byteBuffers, 0, size);
            array.restore();
            array.recycle();
        } else {
            read = ((DatagramChannel)connection.getChannel()).read(buffer.toByteBuffer());
        }
        boolean bl = hasRead = read > 0;
        if (hasRead) {
            buffer.position(oldPos + read);
        }
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(peerAddress);
        }
        return read;
    }

    private int readNonConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            throw new IllegalStateException("Cannot read from non-connection UDP connection into CompositeBuffer");
        }
        ByteBuffer underlyingBB = buffer.toByteBuffer();
        int initialBufferPos = underlyingBB.position();
        SocketAddress peerAddress = ((DatagramChannel)connection.getChannel()).receive(underlyingBB);
        int read = underlyingBB.position() - initialBufferPos;
        boolean bl = hasRead = read > 0;
        if (hasRead) {
            buffer.position(oldPos + read);
        }
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(peerAddress);
        }
        return read;
    }

    public int read(UDPNIOConnection connection, Buffer buffer) throws IOException {
        return this.read(connection, buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean isAllocate;
        int read = 0;
        boolean bl = isAllocate = buffer == null && currentResult != null;
        if (isAllocate) {
            buffer = this.memoryManager.allocateAtLeast(connection.getReadBufferSize());
        }
        try {
            read = connection.isConnected() ? this.readConnected(connection, buffer, currentResult) : this.readNonConnected(connection, buffer, currentResult);
            connection.onRead(buffer, read);
        }
        catch (Exception e) {
            read = -1;
        }
        finally {
            if (isAllocate) {
                if (read <= 0) {
                    buffer.dispose();
                } else {
                    buffer.allowBufferDispose(true);
                }
            }
        }
        return read;
    }

    public long write(UDPNIOConnection connection, SocketAddress dstAddress, WritableMessage message) throws IOException {
        return this.write(connection, dstAddress, message, null);
    }

    public long write(UDPNIOConnection connection, SocketAddress dstAddress, WritableMessage message, WriteResult<WritableMessage, SocketAddress> currentResult) throws IOException {
        long written;
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            int oldPos = buffer.position();
            if (dstAddress != null) {
                written = ((DatagramChannel)connection.getChannel()).send(buffer.toByteBuffer(), dstAddress);
            } else if (buffer.isComposite()) {
                ByteBufferArray array = buffer.toByteBufferArray();
                ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
                int size = array.size();
                written = ((DatagramChannel)connection.getChannel()).write(byteBuffers, 0, size);
                array.restore();
                array.recycle();
            } else {
                written = ((DatagramChannel)connection.getChannel()).write(buffer.toByteBuffer());
            }
            if (written > 0L) {
                buffer.position(oldPos + (int)written);
            }
            connection.onWrite(buffer, (int)written);
        } else if (message instanceof FileTransfer) {
            written = ((FileTransfer)message).writeTo((DatagramChannel)connection.getChannel());
        } else {
            throw new IllegalStateException("Unhandled message type");
        }
        if (currentResult != null) {
            currentResult.setMessage(message);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    UDPNIOConnection obtainNIOConnection(DatagramChannel channel) {
        UDPNIOConnection connection = new UDPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    UDPNIOServerConnection obtainServerNIOConnection(DatagramChannel channel) {
        UDPNIOServerConnection connection = new UDPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    protected void configureNIOConnection(UDPNIOConnection connection) {
        connection.configureBlocking(this.isBlocking);
        connection.configureStandalone(this.isStandalone);
        connection.setProcessor(this.processor);
        connection.setProcessorSelector(this.processorSelector);
        connection.setMonitoringProbes((ConnectionProbe[])this.connectionMonitoringConfig.getProbes());
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.jmx.UDPNIOTransport(this);
    }

    class TransportBindingHandler
    extends UDPNIOBindingHandler {
        public TransportBindingHandler() {
            super(UDPNIOTransport.this);
        }
    }

    protected class TransportConnectorHandler
    extends UDPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(UDPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return UDPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return UDPNIOTransport.this.getProcessorSelector();
        }
    }

    protected class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        protected RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            SelectionKey selectionKey = result.getSelectionKey();
            UDPNIOConnection connection = (UDPNIOConnection)UDPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }
}

