/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import java.util.List;

public class UserGroupMapping {
    private final EntityType type;
    private String name;
    private List<String> userList;
    private List<String> groupList;

    public UserGroupMapping(EntityType type) {
        this.type = type;
        this.userList = new ArrayList<String>();
        this.groupList = new ArrayList<String>();
        this.name = "";
    }

    public UserGroupMapping(EntityType type, String name) {
        this.type = type;
        this.name = name;
        this.userList = new ArrayList<String>();
        this.groupList = new ArrayList<String>();
    }

    public UserGroupMapping(EntityType type, String name, List<String> userList, List<String> groupList) {
        this.type = type;
        this.name = name;
        this.userList = userList;
        this.groupList = groupList;
    }

    public void addToUserList(String user) {
        this.userList.add(user);
    }

    public void addToGroupList(String group) {
        this.groupList.add(group);
    }

    public void addListToUserList(List<String> users) {
        this.userList.addAll(users);
    }

    public void addListToGroupList(List<String> groups) {
        this.groupList.addAll(groups);
    }

    public EntityType getType() {
        return this.type;
    }

    public void setName() {
        this.name = this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setUserList(List<String> userList) {
        this.userList = userList;
    }

    public List<String> getUserList() {
        return this.userList;
    }

    public void setGroupList(List<String> groupList) {
        this.groupList = groupList;
    }

    public List<String> getGroupList() {
        return this.groupList;
    }

    public static enum EntityType {
        USER("u"),
        GROUP("g");

        private final String name;

        private EntityType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

