/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.dynamic;

import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.dynamic.Concatenator;
import org.apache.hadoop.util.dynamic.DynConstructors;
import org.apache.hadoop.util.dynamic.DynMethods;
import org.junit.Assert;
import org.junit.Test;

public class TestDynMethods
extends AbstractHadoopTestBase {
    @Test
    public void testNoImplCall() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat");
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> ((DynMethods.Builder)builder).build());
    }

    @Test
    public void testMissingClass() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> builder.build());
    }

    @Test
    public void testMissingMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, "cat2strings", new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> builder.build());
    }

    @Test
    public void testFirstImplReturned() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat2 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should call the 2-arg version successfully", (Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b"}));
        Assert.assertEquals((String)"Should ignore extra arguments", (Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b", "c"}));
        DynMethods.UnboundMethod cat3 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).build();
        Assert.assertEquals((String)"Should call the 3-arg version successfully", (Object)"a-b-c", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b", "c"}));
        Assert.assertEquals((String)"Should call the 3-arg version null padding", (Object)"a-b-null", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testVarArgs() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String[].class}).buildChecked();
        Assert.assertEquals((String)"Should use the varargs version", (Object)"abcde", (Object)cat.invokeChecked((Object)new Concatenator(), new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
        Assert.assertEquals((String)"Should use the varargs version", (Object)"abcde", (Object)cat.bind((Object)new Concatenator()).invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
    }

    @Test
    public void testIncorrectArguments() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> cat.invoke((Object)obj, new Object[]{3, 4}));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> cat.invokeChecked((Object)obj, new Object[]{3, 4}));
    }

    @Test
    public void testExceptionThrown() throws Exception {
        Concatenator.SomeCheckedException exc = new Concatenator.SomeCheckedException();
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{Exception.class}).buildChecked();
        LambdaTestUtils.intercept(Concatenator.SomeCheckedException.class, () -> cat.invokeChecked((Object)obj, new Object[]{exc}));
        LambdaTestUtils.intercept(RuntimeException.class, () -> cat.invoke((Object)obj, new Object[]{exc}));
    }

    @Test
    public void testNameChange() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("cat").impl(Concatenator.class, "concat", new Class[]{String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should find 2-arg concat method", (Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testStringClassname() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class.getName(), new Class[]{String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should find 2-arg concat method", (Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testHiddenMethod() throws Exception {
        Concatenator obj = new Concatenator("-");
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> new DynMethods.Builder("setSeparator").impl(Concatenator.class, new Class[]{String.class}).buildChecked());
        DynMethods.UnboundMethod changeSep = new DynMethods.Builder("setSeparator").hiddenImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assert.assertNotNull((String)"Should find hidden method with hiddenImpl", (Object)changeSep);
        changeSep.invokeChecked((Object)obj, new Object[]{"/"});
        Assert.assertEquals((String)"Should use separator / instead of -", (Object)"a/b", (Object)obj.concat("a", "b"));
    }

    @Test
    public void testBoundMethod() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        DynMethods.BoundMethod dashCat = cat.bind((Object)new Concatenator("-"));
        DynMethods.BoundMethod underCat = cat.bind((Object)new Concatenator("_"));
        Assert.assertEquals((String)"Should use '-' object without passing", (Object)"a-b", (Object)dashCat.invoke(new Object[]{"a", "b"}));
        Assert.assertEquals((String)"Should use '_' object without passing", (Object)"a_b", (Object)underCat.invoke(new Object[]{"a", "b"}));
        DynMethods.BoundMethod slashCat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked((Object)new Concatenator("/"));
        Assert.assertEquals((String)"Should use bound object from builder without passing", (Object)"a/b", (Object)slashCat.invoke(new Object[]{"a", "b"}));
    }

    @Test
    public void testBindStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class});
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        DynMethods.UnboundMethod staticCat = builder.buildChecked();
        Assert.assertTrue((String)"Should be static", (boolean)staticCat.isStatic());
        LambdaTestUtils.intercept(IllegalStateException.class, () -> staticCat.bind((Object)new Concatenator()));
    }

    @Test
    public void testStaticMethod() throws Exception {
        DynMethods.StaticMethod staticCat = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class}).buildStaticChecked();
        Assert.assertEquals((String)"Should call varargs static method cat(String...)", (Object)"abcde", (Object)staticCat.invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
    }

    @Test
    public void testNonStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStatic());
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStaticChecked());
        DynMethods.UnboundMethod cat2 = builder.buildChecked();
        Assert.assertFalse((String)"concat(String,String) should not be static", (boolean)cat2.isStatic());
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.UnboundMethod)cat2).asStatic());
    }

    @Test
    public void testConstructorImpl() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("newConcatenator").ctorImpl(Concatenator.class, new Class[]{String.class}).impl(Concatenator.class, new Class[]{String.class});
        DynMethods.UnboundMethod newConcatenator = builder.buildChecked();
        Assert.assertTrue((String)"Should find constructor implementation", (boolean)(newConcatenator instanceof DynConstructors.Ctor));
        Assert.assertTrue((String)"Constructor should be a static method", (boolean)newConcatenator.isStatic());
        Assert.assertFalse((String)"Constructor should not be NOOP", (boolean)newConcatenator.isNoop());
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        Concatenator concatenator = (Concatenator)newConcatenator.asStatic().invoke(new Object[]{"*"});
        Assert.assertEquals((String)"Should function as a concatenator", (Object)"a*b", (Object)concatenator.concat("a", "b"));
        concatenator = (Concatenator)newConcatenator.asStatic().invokeChecked(new Object[]{"@"});
        Assert.assertEquals((String)"Should function as a concatenator", (Object)"a@b", (Object)concatenator.concat("a", "b"));
    }

    @Test
    public void testConstructorImplAfterFactoryMethod() throws Exception {
        DynMethods.UnboundMethod newConcatenator = new DynMethods.Builder("newConcatenator").impl(Concatenator.class, new Class[]{String.class}).ctorImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assert.assertFalse((String)"Should find factory method before constructor method", (boolean)(newConcatenator instanceof DynConstructors.Ctor));
    }

    @Test
    public void testNoop() throws Exception {
        DynMethods.UnboundMethod noop = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).orNoop().buildChecked();
        Assert.assertTrue((String)"No implementation found, should return NOOP", (boolean)noop.isNoop());
        Assert.assertNull((String)"NOOP should always return null", (Object)noop.invoke((Object)new Concatenator(), new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be called with null", (Object)noop.invoke(null, new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be bound", (Object)noop.bind((Object)new Concatenator()).invoke(new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be bound to null", (Object)noop.bind(null).invoke(new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be static", (Object)noop.asStatic().invoke(new Object[]{"a"}));
    }
}

