/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.TestSSLHttpServer;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSSLHttpServerConfigs {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestSSLHttpServer.class.getSimpleName());
    private static Configuration conf;
    private static Configuration sslConf;
    private static String keystoreDir;
    private static String sslConfDir;
    private static final String SERVER_PWD = "serverP";
    private static final String CLIENT_PWD = "clientP";
    private static final String TRUST_STORE_PWD = "trustP";

    @Before
    public void start() throws Exception {
        TestSSLHttpServer.turnOnSSLDebugLogging();
        TestSSLHttpServer.storeHttpsCipherSuites();
        conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoreDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
    }

    @After
    public void shutdown() throws Exception {
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoreDir, sslConfDir);
        TestSSLHttpServer.restoreHttpsCipherSuites();
        TestSSLHttpServer.restoreSSLDebugLogging();
    }

    private void setupKeyStores(String serverPassword, String clientPassword, String trustStorePassword) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoreDir, sslConfDir, conf, false, true, "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, \nSSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,  SSL_RSA_EXPORT_WITH_RC4_40_MD5,\t \nSSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5 \t", serverPassword, clientPassword, trustStorePassword);
        sslConf = KeyStoreTestUtil.getSslConfig();
        sslConf.set("hadoop.ssl.enabled.protocols", "TLSv1.2");
        conf.set("hadoop.ssl.enabled.protocols", "TLSv1.2");
    }

    private HttpServer2 setupServer(String keyStoreKeyPassword, String keyStorePassword, String trustStorePassword) throws Exception {
        HttpServer2 server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(keyStoreKeyPassword).keyStore(sslConf.get("ssl.server.keystore.location"), keyStorePassword, sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), trustStorePassword, sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list")).includeCiphers(sslConf.get("ssl.server.include.cipher.list")).build();
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testServerStart(String keyStoreKeyPassword, String keyStorePassword, String trustStorePassword) throws Exception {
        final HttpServer2 server = this.setupServer(keyStoreKeyPassword, keyStorePassword, trustStorePassword);
        try {
            server.start();
            GenericTestUtils.waitFor(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return server.isAlive();
                }
            }, 200L, 100000L);
        }
        finally {
            server.stop();
        }
    }

    @Test(timeout=120000L)
    public void testServerSetup() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        this.testServerStart(SERVER_PWD, SERVER_PWD, TRUST_STORE_PWD);
    }

    @Test(timeout=120000L)
    public void testServerSetupWithoutTrustPassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        this.testServerStart(SERVER_PWD, SERVER_PWD, null);
    }

    @Test(timeout=120000L)
    public void testServerSetupWithoutKeyStorePassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        this.testServerStart(SERVER_PWD, null, null);
    }

    @Test(timeout=120000L)
    public void testServerSetupWithoutKeyStoreKeyPassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        this.testServerStart(null, SERVER_PWD, null);
    }

    @Test(timeout=120000L)
    public void testServerSetupWithNoKeyStorePassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        try {
            this.testServerStart(null, null, null);
            Assert.fail((String)"Server should have failed to start without any KeyStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Problem starting http server", e);
        }
    }

    @Test(timeout=120000L)
    public void testServerSetupWithWrongKeyStorePassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, TRUST_STORE_PWD);
        try {
            this.testServerStart(SERVER_PWD, "wrongPassword", null);
            Assert.fail((String)"Server should have failed to start with wrong KeyStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Keystore was tampered with, or password was incorrect", e);
        }
        try {
            this.testServerStart("wrongPassword", SERVER_PWD, null);
            Assert.fail((String)"Server should have failed to start with wrong KeyStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Problem starting http server", e);
            GenericTestUtils.assertExceptionContains("Cannot recover key", e.getCause());
        }
    }

    @Test(timeout=120000L)
    public void testKeyStoreSetupWithoutTrustStorePassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, CLIENT_PWD, "");
        this.testServerStart(SERVER_PWD, SERVER_PWD, null);
        try {
            this.testServerStart(SERVER_PWD, SERVER_PWD, "wrongPassword");
            Assert.fail((String)"Server should have failed to start with wrong TrustStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Keystore was tampered with, or password was incorrect", e);
        }
    }

    @Test(timeout=120000L)
    public void testKeyStoreSetupWithoutKeyStorePassword() throws Exception {
        this.setupKeyStores(SERVER_PWD, "", TRUST_STORE_PWD);
        this.testServerStart(SERVER_PWD, null, TRUST_STORE_PWD);
        try {
            this.testServerStart(SERVER_PWD, "wrongPassword", TRUST_STORE_PWD);
            Assert.fail((String)"Server should have failed to start with wrong KeyStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Keystore was tampered with, or password was incorrect", e);
        }
    }

    @Test(timeout=120000L)
    public void testKeyStoreSetupWithoutPassword() throws Exception {
        this.setupKeyStores("", "", "");
        this.testServerStart("", null, null);
        this.testServerStart(null, "", null);
        try {
            this.testServerStart(null, null, null);
            Assert.fail((String)"Server should have failed to start without KeyStore password.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Problem starting http server", e);
            GenericTestUtils.assertExceptionContains("Password must not be null", e.getCause());
        }
    }
}

