/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.localfs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractContractVectoredReadTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestLocalFSContractVectoredRead
extends AbstractContractVectoredReadTest {
    public TestLocalFSContractVectoredRead(String bufferType) {
        super(bufferType);
    }

    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testChecksumValidationDuringVectoredRead() throws Exception {
        Path testPath = this.path("big_range_checksum_file");
        ArrayList<FileRange> someRandomRanges = new ArrayList<FileRange>();
        someRandomRanges.add(FileRange.createFileRange((long)10L, (int)1024));
        someRandomRanges.add(FileRange.createFileRange((long)1040L, (int)1024));
        this.validateCheckReadException(testPath, 65536, someRandomRanges);
    }

    @Test
    public void testChecksumValidationDuringVectoredReadSmallFile() throws Exception {
        Path testPath = this.path("big_range_checksum_file");
        int length = 471;
        ArrayList<FileRange> smallFileRanges = new ArrayList<FileRange>();
        smallFileRanges.add(FileRange.createFileRange((long)10L, (int)50));
        smallFileRanges.add(FileRange.createFileRange((long)100L, (int)20));
        this.validateCheckReadException(testPath, 471, smallFileRanges);
    }

    private void validateCheckReadException(Path testPath, int length, List<FileRange> ranges) throws Exception {
        LocalFileSystem localFs = (LocalFileSystem)this.getFileSystem();
        byte[] datasetCorrect = ContractTestUtils.dataset(length, 97, 32);
        try (FSDataOutputStream out = localFs.create(testPath, true);){
            out.write(datasetCorrect);
        }
        Path checksumPath = localFs.getChecksumFile(testPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(checksumPath)).describedAs("Checksum file should be present", new Object[0])).isTrue();
        CompletableFuture fis = localFs.openFile(testPath).build();
        try (FSDataInputStream in = (FSDataInputStream)fis.get();){
            in.readVectored(ranges, this.getAllocate());
            ContractTestUtils.validateVectoredReadResult(ranges, datasetCorrect, 0L);
        }
        byte[] datasetCorrupted = ContractTestUtils.dataset(length, 97, 64);
        try (FSDataOutputStream out = localFs.getRaw().create(testPath, true);){
            out.write(datasetCorrupted);
        }
        CompletableFuture fisN = localFs.openFile(testPath).build();
        try (FSDataInputStream in = (FSDataInputStream)fisN.get();){
            in.readVectored(ranges, this.getAllocate());
            LambdaTestUtils.intercept(ChecksumException.class, () -> ContractTestUtils.validateVectoredReadResult(ranges, datasetCorrupted, 0L));
        }
    }

    @Test
    public void tesChecksumVectoredReadBoundaries() throws Exception {
        Path testPath = this.path("boundary_range_checksum_file");
        int length = 1071;
        LocalFileSystem localFs = (LocalFileSystem)this.getFileSystem();
        byte[] datasetCorrect = ContractTestUtils.dataset(1071, 97, 32);
        try (FSDataOutputStream out = localFs.create(testPath, true);){
            out.write(datasetCorrect);
        }
        Path checksumPath = localFs.getChecksumFile(testPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(checksumPath)).describedAs("Checksum file should be present at {} ", new Object[]{checksumPath})).isTrue();
        CompletableFuture fis = localFs.openFile(testPath).build();
        ArrayList<FileRange> smallRange = new ArrayList<FileRange>();
        smallRange.add(FileRange.createFileRange((long)1000L, (int)71));
        try (FSDataInputStream in = (FSDataInputStream)fis.get();){
            in.readVectored(smallRange, this.getAllocate());
            ContractTestUtils.validateVectoredReadResult(smallRange, datasetCorrect, 0L);
        }
    }
}

