/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Delete {
    Delete() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Rm.class, "-rm");
        factory.addClass(Rmdir.class, "-rmdir");
        factory.addClass(Rmr.class, "-rmr");
        factory.addClass(Expunge.class, "-expunge");
    }

    static class Expunge
    extends FsCommand {
        private static final String OPTION_FILESYSTEM = "fs";
        public static final String NAME = "expunge";
        public static final String USAGE = "[-immediate] [-fs <path>]";
        public static final String DESCRIPTION = "Delete files from the trash that are older than the retention threshold";
        private boolean emptyImmediately = false;
        private String fsArgument;

        Expunge() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, 2, "immediate");
            cf.addOptionWithValue(OPTION_FILESYSTEM);
            cf.parse(args);
            this.emptyImmediately = cf.getOpt("immediate");
            this.fsArgument = cf.getOptValue(OPTION_FILESYSTEM);
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            FileSystem[] childFileSystems;
            if (this.fsArgument != null && this.fsArgument.length() != 0) {
                this.getConf().set("fs.defaultFS", this.fsArgument);
            }
            if (null != (childFileSystems = FileSystem.get(this.getConf()).getChildFileSystems())) {
                for (FileSystem fs : childFileSystems) {
                    Trash trash = new Trash(fs, this.getConf());
                    if (this.emptyImmediately) {
                        trash.expungeImmediately();
                        continue;
                    }
                    trash.expunge();
                    trash.checkpoint();
                }
            } else {
                Trash trash = new Trash(this.getConf());
                if (this.emptyImmediately) {
                    trash.expungeImmediately();
                } else {
                    trash.expunge();
                    trash.checkpoint();
                }
            }
        }
    }

    static class Rmdir
    extends FsCommand {
        public static final String NAME = "rmdir";
        public static final String USAGE = "[--ignore-fail-on-non-empty] <dir> ...";
        public static final String DESCRIPTION = "Removes the directory entry specified by each directory argument, provided it is empty.\n";
        private boolean ignoreNonEmpty = false;

        Rmdir() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "-ignore-fail-on-non-empty");
            cf.parse(args);
            this.ignoreNonEmpty = cf.getOpt("-ignore-fail-on-non-empty");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
            if (item.fs.listStatus(item.path).length == 0) {
                if (!item.fs.delete(item.path, false)) {
                    throw new PathIOException(item.toString());
                }
            } else if (!this.ignoreNonEmpty) {
                throw new PathIsNotEmptyDirectoryException(item.toString());
            }
        }
    }

    static class Rmr
    extends Rm {
        public static final String NAME = "rmr";

        Rmr() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-r");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "-rm -r";
        }
    }

    public static class Rm
    extends FsCommand {
        public static final String NAME = "rm";
        public static final String USAGE = "[-f] [-r|-R] [-skipTrash] [-safely] <src> ...";
        public static final String DESCRIPTION = "Delete all files that match the specified file pattern. Equivalent to the Unix command \"rm <src>\"\n-f: If the file does not exist, do not display a diagnostic message or modify the exit status to reflect an error.\n-[rR]:  Recursively deletes directories.\n-skipTrash: option bypasses trash, if enabled, and immediately deletes <src>.\n-safely: option requires safety confirmation, if enabled, requires confirmation before deleting large directory with more than <hadoop.shell.delete.limit.num.files> files. Delay is expected when walking over large directory recursively to count the number of files to be deleted before the confirmation.\n";
        private boolean skipTrash = false;
        private boolean deleteDirs = false;
        private boolean ignoreFNF = false;
        private boolean safeDelete = false;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "f", "r", "R", "skipTrash", "safely");
            cf.parse(args);
            this.ignoreFNF = cf.getOpt("f");
            this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
            this.skipTrash = cf.getOpt("skipTrash");
            this.safeDelete = cf.getOpt("safely");
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            try {
                return super.expandArgument(arg);
            }
            catch (PathNotFoundException e) {
                if (!this.ignoreFNF) {
                    throw e;
                }
                return new LinkedList<PathData>();
            }
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            if (!this.ignoreFNF) {
                super.processNonexistentPath(item);
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory() && !this.deleteDirs) {
                throw new PathIsDirectoryException(item.toString());
            }
            PathData parent = new PathData(item.stat.getPath().getParent().toString(), item.fs.getConf());
            if (parent.stat.isSymlink()) {
                item = new PathData(new Path(FileUtil.fixSymlinkPath(parent), item.path.getName()).toString(), item.fs.getConf());
            }
            if (this.moveToTrash(item) || !this.canBeSafelyDeleted(item)) {
                return;
            }
            if (!item.fs.delete(item.path, this.deleteDirs)) {
                throw new PathIOException(item.toString());
            }
            this.out.println("Deleted " + item);
        }

        private boolean canBeSafelyDeleted(PathData item) throws IOException {
            ContentSummary cs;
            long numFiles;
            long deleteLimit;
            boolean shouldDelete = true;
            if (this.safeDelete && (deleteLimit = this.getConf().getLong("hadoop.shell.safely.delete.limit.num.files", 100L)) > 0L && (numFiles = (cs = item.fs.getContentSummary(item.path)).getFileCount()) > deleteLimit && !ToolRunner.confirmPrompt("Proceed deleting " + numFiles + " files?")) {
                System.err.println("Delete aborted at user request.\n");
                shouldDelete = false;
            }
            return shouldDelete;
        }

        private boolean moveToTrash(PathData item) throws IOException {
            boolean success = false;
            if (!this.skipTrash) {
                try {
                    success = Trash.moveToAppropriateTrash(item.fs, item.path, this.getConf());
                }
                catch (FileNotFoundException fnfe) {
                    throw fnfe;
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if (ioe.getCause() != null) {
                        msg = msg + ": " + ioe.getCause().getMessage();
                    }
                    throw new IOException(msg + ". Consider using -skipTrash option", ioe);
                }
            }
            return success;
        }
    }
}

