/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRaceWhenRelogin
extends KerberosSecurityTestcase {
    private int numThreads = 10;
    private String clientPrincipal = "client";
    private String serverProtocol = "server";
    private String[] serverProtocols;
    private String host = "localhost";
    private String serverPrincipal = this.serverProtocol + "/" + this.host;
    private String[] serverPrincipals;
    private File keytabFile;
    private Configuration conf = new Configuration();
    private Map<String, String> props;
    private UserGroupInformation ugi;

    @Before
    public void setUp() throws Exception {
        this.keytabFile = new File(this.getWorkDir(), "keytab");
        this.serverProtocols = new String[this.numThreads];
        this.serverPrincipals = new String[this.numThreads];
        for (int i = 0; i < this.numThreads; ++i) {
            this.serverProtocols[i] = this.serverProtocol + i;
            this.serverPrincipals[i] = this.serverProtocols[i] + "/" + this.host;
        }
        String[] principals = Arrays.copyOf(this.serverPrincipals, this.serverPrincipals.length + 2);
        principals[this.numThreads] = this.serverPrincipal;
        principals[this.numThreads + 1] = this.clientPrincipal;
        this.getKdc().createPrincipal(this.keytabFile, principals);
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        this.props = new HashMap<String, String>();
        this.props.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.AUTHENTICATION.saslQop);
        this.ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.clientPrincipal, (String)this.keytabFile.getAbsolutePath());
    }

    private void relogin(AtomicBoolean pass) {
        for (int i = 0; i < 100; ++i) {
            try {
                this.ugi.reloginFromKeytab();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            KerberosTicket tgt = this.ugi.getSubject().getPrivateCredentials().stream().filter(c -> c instanceof KerberosTicket).map(c -> (KerberosTicket)c).findFirst().get();
            if (!tgt.getServer().getName().startsWith("krbtgt")) {
                pass.set(false);
                return;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void getServiceTicket(AtomicBoolean running, final String serverProtocol) {
        while (running.get()) {
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SaslClient client = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.KERBEROS.getMechanismName()}, TestRaceWhenRelogin.this.clientPrincipal, serverProtocol, TestRaceWhenRelogin.this.host, TestRaceWhenRelogin.this.props, null);
                        client.evaluateChallenge(new byte[0]);
                        client.dispose();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextInt(100));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void test() throws InterruptedException, IOException {
        AtomicBoolean pass = new AtomicBoolean(true);
        Thread reloginThread = new Thread(() -> this.relogin(pass), "Relogin");
        AtomicBoolean running = new AtomicBoolean(true);
        Thread[] getServiceTicketThreads = new Thread[this.numThreads];
        for (int i = 0; i < this.numThreads; ++i) {
            String serverProtocol = this.serverProtocols[i];
            getServiceTicketThreads[i] = new Thread(() -> this.getServiceTicket(running, serverProtocol), "GetServiceTicket-" + i);
        }
        for (Thread getServiceTicketThread : getServiceTicketThreads) {
            getServiceTicketThread.start();
        }
        reloginThread.start();
        reloginThread.join();
        running.set(false);
        for (Thread getServiceTicketThread : getServiceTicketThreads) {
            getServiceTicketThread.join();
        }
        Assert.assertTrue((String)"tgt is not the first ticket after relogin", (boolean)pass.get());
    }
}

