/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maprfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRPathId
implements PathId {
    private static final Logger LOG = LoggerFactory.getLogger(MapRPathId.class);
    private String fid = "";
    private long[] ips = new long[0];

    @Override
    public String getFid() {
        return this.fid;
    }

    @Override
    public long[] getIPs() {
        return this.ips;
    }

    @Override
    public void setFid(String fid) {
        this.fid = fid;
    }

    @Override
    public void setIps(long[] ips) {
        this.ips = ips;
    }

    @Override
    public void setIps(List<Long> listIps) {
        this.ips = new long[listIps.size()];
        for (int i = 0; i < listIps.size(); ++i) {
            this.ips[i] = listIps.get(i);
        }
    }

    @Override
    public void writeFields(DataOutput out) throws IOException {
        LOG.debug("Writing MapRPathId with Fid: {}, Ips: {}", (Object)this.fid, (Object)Arrays.toString(this.ips));
        WritableUtils.writeString(out, this.fid);
        WritableUtils.writeVInt(out, this.ips.length);
        for (long l : this.ips) {
            WritableUtils.writeVLong(out, l);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fid = WritableUtils.readString(in);
        this.ips = new long[WritableUtils.readVInt(in)];
        for (int i = 0; i < this.ips.length; ++i) {
            this.ips[i] = WritableUtils.readVLong(in);
        }
        LOG.debug("Reading MapRPathId with Fid: {}, Ips: {}", (Object)this.fid, (Object)Arrays.toString(this.ips));
    }

    public boolean equals(Object other) {
        if (!(other instanceof MapRPathId)) {
            return false;
        }
        MapRPathId otherFileId = (MapRPathId)other;
        return otherFileId.getFid().equals(this.fid) && Arrays.equals(otherFileId.getIPs(), this.ips);
    }

    public String toString() {
        return this.getClass() + "[ " + this.fid + " ipaddrs=" + Arrays.toString(this.ips) + " ]";
    }
}

