/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreTestUtil {
    public static final String SERVER_KEY_STORE_PASSWORD_DEFAULT = "serverP";
    public static final String CLIENT_KEY_STORE_PASSWORD_DEFAULT = "clientP";
    public static final String TRUST_STORE_PASSWORD_DEFAULT = "trustP";

    public static String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws CertificateException, IllegalStateException, OperatorCreationException, CertIOException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        KeyPair keyPair = pair;
        BouncyCastleFipsProvider bcProvider = new BouncyCastleFipsProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(dn);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        ContentSigner contentSigner = new JcaContentSignerBuilder(algorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(true);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
        return cert;
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(1024);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveKeyStore(KeyStore ks, String filename, String password) throws GeneralSecurityException, IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    public static void createKeyStore(String filename, String password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStoreTestUtil.createKeyStore(filename, password, alias, privateKey, new Certificate[]{cert});
    }

    public static void createKeyStore(String filename, String password, String alias, Key privateKey, Certificate[] certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.toCharArray(), certs);
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createKeyStore(String filename, String password, String keyPassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setCertificateEntry(alias, cert);
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, String password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static KeyStore bytesToKeyStore(byte[] bytes, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStoreTestUtil.createEmptyKeyStore();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        keyStore.load(bais, password.toCharArray());
        return keyStore;
    }

    public static void cleanupSSLConfig(String keystoresDir, String sslConfDir) throws Exception {
        File f = new File(keystoresDir + "/clientKS.jks");
        f.delete();
        f = new File(keystoresDir + "/serverKS.jks");
        f.delete();
        f = new File(keystoresDir + "/trustKS.jks");
        f.delete();
        f = new File(sslConfDir + "/ssl-client.xml");
        f.delete();
        f = new File(sslConfDir + "/ssl-server.xml");
        f.delete();
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true);
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true, "");
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore, String excludeCiphers) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, trustStore, excludeCiphers, SERVER_KEY_STORE_PASSWORD_DEFAULT, CLIENT_KEY_STORE_PASSWORD_DEFAULT, TRUST_STORE_PASSWORD_DEFAULT);
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore, String excludeCiphers, String serverPassword, String clientPassword, String trustPassword) throws Exception {
        String clientKS = keystoresDir + "/clientKS.jks";
        String serverKS = keystoresDir + "/serverKS.jks";
        String trustKS = null;
        File sslClientConfFile = new File(sslConfDir, KeyStoreTestUtil.getClientSSLConfigFileName());
        File sslServerConfFile = new File(sslConfDir, KeyStoreTestUtil.getServerSSLConfigFileName());
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        if (useClientCert) {
            KeyPair cKP = KeyStoreTestUtil.generateKeyPair("RSA");
            X509Certificate cCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=client", cKP, 30, "SHA256WithRSA");
            KeyStoreTestUtil.createKeyStore(clientKS, clientPassword, "client", (Key)cKP.getPrivate(), cCert);
            certs.put("client", cCert);
        }
        KeyPair sKP = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", sKP, 30, "SHA256WithRSA");
        KeyStoreTestUtil.createKeyStore(serverKS, serverPassword, "server", (Key)sKP.getPrivate(), sCert);
        certs.put("server", sCert);
        if (trustStore) {
            trustKS = keystoresDir + "/trustKS.jks";
            KeyStoreTestUtil.createTrustStore(trustKS, trustPassword, certs);
        }
        Configuration clientSSLConf = KeyStoreTestUtil.createClientSSLConfig(clientKS, clientPassword, clientPassword, trustKS, trustPassword, excludeCiphers);
        Configuration serverSSLConf = KeyStoreTestUtil.createServerSSLConfig(serverKS, serverPassword, serverPassword, trustKS, trustPassword, excludeCiphers);
        KeyStoreTestUtil.saveConfig(sslClientConfFile, clientSSLConf);
        KeyStoreTestUtil.saveConfig(sslServerConfFile, serverSSLConf);
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        conf.set("hadoop.ssl.client.conf", sslClientConfFile.getName());
        conf.set("hadoop.ssl.server.conf", sslServerConfFile.getName());
        conf.setBoolean("hadoop.ssl.require.client.cert", useClientCert);
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS, String trustPassword) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, trustPassword, "");
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS, String trustPassword, String excludeCiphers) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, trustPassword, excludeCiphers);
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS, String trustPassword) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, trustPassword, "");
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS, String trustPassword, String excludeCiphers) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, trustPassword, excludeCiphers);
    }

    public static String getClientSSLConfigFileName() {
        return KeyStoreTestUtil.getSSLConfigFileName("ssl-client");
    }

    public static String getServerSSLConfigFileName() {
        return KeyStoreTestUtil.getSSLConfigFileName("ssl-server");
    }

    private static String getSSLConfigFileName(String base) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        String fileSuffix = testUniqueForkId != null ? "-" + testUniqueForkId : "";
        return base + fileSuffix + ".xml";
    }

    private static Configuration createSSLConfig(SSLFactory.Mode mode, String keystore, String password, String keyPassword, String trustKS, String trustStorePwd, String excludeCiphers) {
        Configuration sslConf = new Configuration(false);
        if (keystore != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.location"), keystore);
        }
        if (password != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.password"), password);
        }
        if (keyPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.keypassword"), keyPassword);
        }
        if (trustKS != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.location"), trustKS);
        }
        if (trustStorePwd != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.password"), trustStorePwd);
        }
        if (null != excludeCiphers && !excludeCiphers.isEmpty()) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.exclude.cipher.list"), excludeCiphers);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        return sslConf;
    }

    public static void saveConfig(File file, Configuration conf) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            conf.writeXml((Writer)writer);
        }
    }

    public static void provisionPasswordsToCredentialProvider() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        try {
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), storepass);
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.keypassword"), keypass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Configuration getSslConfig() {
        Configuration sslConf = new Configuration(false);
        String sslServerConfFile = KeyStoreTestUtil.getServerSSLConfigFileName();
        String sslClientConfFile = KeyStoreTestUtil.getClientSSLConfigFileName();
        sslConf.addResource(sslServerConfFile);
        sslConf.addResource(sslClientConfFile);
        sslConf.set("hadoop.ssl.server.conf", sslServerConfFile);
        sslConf.set("hadoop.ssl.client.conf", sslClientConfFile);
        return sslConf;
    }

    public static void setAllowAllSSL(HttpsURLConnection httpsConn) throws KeyManagementException, NoSuchAlgorithmException {
        KeyStoreTestUtil.setAllowAllSSL(httpsConn, null);
    }

    public static void setAllowAllSSL(HttpsURLConnection httpsConn, final X509Certificate clientCert, final KeyPair clientKeyPair) throws KeyManagementException, NoSuchAlgorithmException {
        X509KeyManager km = new X509KeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return new String[]{"client"};
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return "client";
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return null;
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                return new X509Certificate[]{clientCert};
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return clientKeyPair.getPrivate();
            }
        };
        KeyStoreTestUtil.setAllowAllSSL(httpsConn, km);
    }

    private static void setAllowAllSSL(HttpsURLConnection httpsConn, KeyManager km) throws KeyManagementException, NoSuchAlgorithmException {
        KeyManager[] keyManagerArray;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
        if (km == null) {
            keyManagerArray = null;
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = km;
        }
        KeyManager[] kms = keyManagerArray;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(kms, trustAllCerts, new SecureRandom());
        httpsConn.setSSLSocketFactory(sc.getSocketFactory());
        httpsConn.setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
    }
}

