/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReloadingX509TrustManager {
    private static final String BASEDIR = System.getProperty("test.build.data", "target/test-dir") + "/" + TestReloadingX509TrustManager.class.getSimpleName();
    private X509Certificate cert1;
    private X509Certificate cert2;

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @Test(expected=IOException.class)
    public void testLoadMissingTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testLoadCorruptTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        FileOutputStream os = new FileOutputStream(truststoreLocation);
        ((OutputStream)os).write(1);
        ((OutputStream)os).close();
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReload() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30);
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30);
        String truststoreLocation = BASEDIR + "/testreload.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Thread.sleep(tm.getReloadInterval() + 1000L);
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            certs.put("cert1", this.cert1);
            certs.put("cert2", this.cert2);
            KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", certs);
            Assert.assertEquals((long)10L, (long)tm.getReloadInterval());
            Thread.sleep(tm.getReloadInterval() + 200L);
            Assert.assertEquals((long)2L, (long)tm.getAcceptedIssuers().length);
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadMissingTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30);
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30);
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            new File(truststoreLocation).delete();
            Thread.sleep(tm.getReloadInterval() + 200L);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadCorruptTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30);
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30);
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            FileOutputStream os = new FileOutputStream(truststoreLocation);
            ((OutputStream)os).write(1);
            ((OutputStream)os).close();
            new File(truststoreLocation).setLastModified(System.currentTimeMillis() - 1000L);
            Thread.sleep(tm.getReloadInterval() + 200L);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            tm.destroy();
        }
    }
}

